/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern;

import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.PerformanceSensitive;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;
import elf4j.engine.logging.pattern.UndefinedPatternElement;
import java.util.ArrayList;
import java.util.List;

public record LogPattern(List<PatternElement> patternElements) implements PatternElement
{
    public static LogPattern from(String pattern) {
        if (pattern.trim().isEmpty()) {
            throw new IllegalArgumentException("Unexpected blank pattern");
        }
        ArrayList<PatternElement> elements = new ArrayList<PatternElement>();
        int length = pattern.length();
        int i = 0;
        while (i < length) {
            String element;
            int j;
            if (pattern.charAt(i) == '{') {
                j = pattern.indexOf(125, i);
                if (j != -1) {
                    element = pattern.substring(i + 1, j);
                    i = j + 1;
                } else {
                    element = pattern.substring(i);
                    i = length;
                }
                elements.add(PredefinedPatternElementType.parsePredefinedPatternELement(element));
                continue;
            }
            j = pattern.indexOf(123, i);
            if (j != -1) {
                element = pattern.substring(i, j);
                i = j;
            } else {
                element = pattern.substring(i);
                i = length;
            }
            elements.add(UndefinedPatternElement.from(element));
        }
        return new LogPattern(elements);
    }

    @Override
    public boolean includeCallerDetail() {
        return this.patternElements.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        for (PatternElement element : this.patternElements) {
            element.render(logEvent, target);
        }
    }
}

