/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern.predefined;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.PrettifyOutputStream;
import com.dslplatform.json.runtime.Settings;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;
import elf4j.engine.logging.util.StackTraces;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.MDC;

public record JsonElement(boolean includeCallerThread, boolean includeCallerDetail, boolean prettyPrint) implements PatternElement
{
    private static final String CALLER_DETAIL = "caller-detail";
    private static final String CALLER_THREAD = "caller-thread";
    private static final String PRETTY = "pretty";
    private static final Set<String> DISPLAY_OPTIONS = Arrays.stream(new String[]{"caller-thread", "caller-detail", "pretty"}).collect(Collectors.toSet());
    private static final DslJson<Object> DSL_JSON = new DslJson(Settings.basicSetup().skipDefaultValues(true).includeServiceLoader());
    private static final String UTF_8 = StandardCharsets.UTF_8.toString();
    private static final int JSON_BYTES_INIT_SIZE = 1024;

    public static JsonElement from(String patternElement) {
        Optional<List<String>> displayOptions = PredefinedPatternElementType.getPatternElementDisplayOptions(patternElement);
        if (displayOptions.isEmpty()) {
            return JsonElement.builder().build();
        }
        Set<String> options = Set.copyOf((Collection)displayOptions.get());
        if (!PredefinedPatternElementType.alphaNumericOnly(DISPLAY_OPTIONS).containsAll(PredefinedPatternElementType.alphaNumericOnly(options))) {
            throw new IllegalArgumentException("Invalid JSON display option inside: " + String.valueOf(options));
        }
        return JsonElement.builder().includeCallerThread(options.contains(CALLER_THREAD)).includeCallerDetail(options.contains(CALLER_DETAIL)).prettyPrint(options.contains(PRETTY)).build();
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try (ByteArrayOutputStream outputStream = this.prettyPrint ? new PrettifyOutputStream((OutputStream)byteArrayOutputStream) : byteArrayOutputStream;){
            DSL_JSON.serialize((Object)JsonLogEntry.from(logEvent, this), (OutputStream)outputStream);
            target.append(byteArrayOutputStream.toString(UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public static JsonElementBuilder builder() {
        return new JsonElementBuilder();
    }

    @Generated
    public static class JsonElementBuilder {
        @Generated
        private boolean includeCallerThread;
        @Generated
        private boolean includeCallerDetail;
        @Generated
        private boolean prettyPrint;

        @Generated
        JsonElementBuilder() {
        }

        @Generated
        public JsonElementBuilder includeCallerThread(boolean includeCallerThread) {
            this.includeCallerThread = includeCallerThread;
            return this;
        }

        @Generated
        public JsonElementBuilder includeCallerDetail(boolean includeCallerDetail) {
            this.includeCallerDetail = includeCallerDetail;
            return this;
        }

        @Generated
        public JsonElementBuilder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        @Generated
        public JsonElement build() {
            return new JsonElement(this.includeCallerThread, this.includeCallerDetail, this.prettyPrint);
        }

        @Generated
        public String toString() {
            return "JsonElement.JsonElementBuilder(includeCallerThread=" + this.includeCallerThread + ", includeCallerDetail=" + this.includeCallerDetail + ", prettyPrint=" + this.prettyPrint + ")";
        }
    }

    @CompiledJson
    record JsonLogEntry(OffsetDateTime timestamp, String level, @Nullable LogEvent.ThreadValue callerThread, @Nullable String loggerName, @Nullable LogEvent.StackFrameValue callerDetail, Map<String, String> context, String message, @Nullable String exception) {
        static JsonLogEntry from(LogEvent logEvent, JsonElement jsonPattern) {
            return JsonLogEntry.builder().timestamp(OffsetDateTime.ofInstant(logEvent.getTimestamp(), ZoneId.systemDefault())).loggerName(logEvent.getLoggerName()).level(logEvent.getLevel().name()).callerThread(jsonPattern.includeCallerThread ? logEvent.getCallerThread() : null).callerDetail(jsonPattern.includeCallerDetail ? Objects.requireNonNull(logEvent.getCallerFrame()) : null).message(logEvent.getResolvedMessage().toString()).context(MDC.getCopyOfContextMap()).exception(logEvent.getThrowable() == null ? null : StackTraces.getTraceAsBuffer(logEvent.getThrowable()).toString()).build();
        }

        @Generated
        public static JsonLogEntryBuilder builder() {
            return new JsonLogEntryBuilder();
        }

        @Generated
        public static class JsonLogEntryBuilder {
            @Generated
            private OffsetDateTime timestamp;
            @Generated
            private String level;
            @Generated
            private @Nullable LogEvent.ThreadValue callerThread;
            @Generated
            private String loggerName;
            @Generated
            private @Nullable LogEvent.StackFrameValue callerDetail;
            @Generated
            private Map<String, String> context;
            @Generated
            private String message;
            @Generated
            private String exception;

            @Generated
            JsonLogEntryBuilder() {
            }

            @Generated
            public JsonLogEntryBuilder timestamp(OffsetDateTime timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder level(String level) {
                this.level = level;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder callerThread(@Nullable LogEvent.ThreadValue callerThread) {
                this.callerThread = callerThread;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder loggerName(@Nullable String loggerName) {
                this.loggerName = loggerName;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder callerDetail(@Nullable LogEvent.StackFrameValue callerDetail) {
                this.callerDetail = callerDetail;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder context(Map<String, String> context) {
                this.context = context;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public JsonLogEntryBuilder exception(@Nullable String exception) {
                this.exception = exception;
                return this;
            }

            @Generated
            public JsonLogEntry build() {
                return new JsonLogEntry(this.timestamp, this.level, this.callerThread, this.loggerName, this.callerDetail, this.context, this.message, this.exception);
            }

            @Generated
            public String toString() {
                return "JsonElement.JsonLogEntry.JsonLogEntryBuilder(timestamp=" + String.valueOf(this.timestamp) + ", level=" + this.level + ", callerThread=" + String.valueOf(this.callerThread) + ", loggerName=" + this.loggerName + ", callerDetail=" + String.valueOf(this.callerDetail) + ", context=" + String.valueOf(this.context) + ", message=" + this.message + ", exception=" + this.exception + ")";
            }
        }
    }
}

