/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern.predefined;

import com.google.common.collect.Iterables;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;

public record LevelElement(int displayLength) implements PatternElement
{
    private static final int UNSPECIFIED = -1;

    public static LevelElement from(String patternElement) {
        return new LevelElement(PredefinedPatternElementType.getPatternElementDisplayOptions(patternElement).map(Iterables::getOnlyElement).map(Integer::parseInt).orElse(-1));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        String level = logEvent.getLevel().name();
        if (this.displayLength == -1) {
            target.append(level);
            return;
        }
        char[] levelChars = level.toCharArray();
        for (int i = 0; i < this.displayLength; ++i) {
            target.append(i < levelChars.length ? levelChars[i] : (char)' ');
        }
    }
}

