/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern.predefined;

import com.google.common.collect.Iterables;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;
import java.util.Objects;

record NameSpaceElement(DisplayOption displayOption, TargetPattern targetPattern) implements PatternElement
{
    private static final DisplayOption DEFAULT_DISPLAY_OPTION = DisplayOption.FULL;

    public static NameSpaceElement from(String patternElement, TargetPattern targetPattern) {
        return new NameSpaceElement(PredefinedPatternElementType.getPatternElementDisplayOptions(patternElement).map(Iterables::getOnlyElement).map(o -> DisplayOption.valueOf(o.toUpperCase())).orElse(DEFAULT_DISPLAY_OPTION), targetPattern);
    }

    @Override
    public boolean includeCallerDetail() {
        return switch (this.targetPattern.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
        };
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        String fullName = switch (this.targetPattern.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> logEvent.getLoggerName();
            case 0 -> Objects.requireNonNull(logEvent.getCallerFrame()).getClassName();
        };
        switch (this.displayOption.ordinal()) {
            case 0: {
                target.append(fullName);
                break;
            }
            case 1: {
                target.append(fullName.substring(fullName.lastIndexOf(46) + 1));
                break;
            }
            case 2: {
                target.append((CharSequence)NameSpaceElement.getCompressedName(fullName));
            }
        }
    }

    private static StringBuilder getCompressedName(String fullName) {
        StringBuilder compressedName = new StringBuilder();
        String[] tokens = fullName.split("\\.");
        String simpleName = tokens[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            compressedName.append(tokens[i].charAt(0)).append('.');
        }
        compressedName.append(simpleName);
        return compressedName;
    }

    static enum DisplayOption {
        FULL,
        SIMPLE,
        COMPRESSED;

    }

    static enum TargetPattern {
        CLASS,
        LOGGER;

    }
}

