/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern.predefined;

import com.google.common.collect.Iterables;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;
import java.util.Arrays;
import java.util.Objects;

public record ThreadElement(DisplayOption threadDisplayOption) implements PatternElement
{
    public static ThreadElement from(String patternElement) {
        return new ThreadElement(PredefinedPatternElementType.getPatternElementDisplayOptions(patternElement).map(Iterables::getOnlyElement).map(DisplayOption::from).orElse(DisplayOption.NAME));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        LogEvent.ThreadValue callerThread = Objects.requireNonNull(logEvent.getCallerThread());
        target.append(this.threadDisplayOption == DisplayOption.ID ? Long.valueOf(callerThread.id()) : callerThread.name());
    }

    static enum DisplayOption {
        ID,
        NAME;


        public static DisplayOption from(String displayOption) {
            return Arrays.stream(DisplayOption.values()).filter(o -> o.name().equalsIgnoreCase(displayOption)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown thread display option: %s. Valid options are: %s".formatted(displayOption, Arrays.toString((Object[])DisplayOption.values()))));
        }
    }
}

