/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.pattern.predefined;

import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.pattern.PredefinedPatternElementType;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record TimestampElement(DateTimeFormatter dateTimeFormatter, TimeZoneOption timeZoneOption) implements PatternElement
{
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSXXX");

    public static TimestampElement from(String patternElement) {
        Optional<List<String>> elementDisplayOption = PredefinedPatternElementType.getPatternElementDisplayOptions(patternElement);
        if (elementDisplayOption.isEmpty()) {
            return new TimestampElement(DEFAULT_DATE_TIME_FORMAT, TimeZoneOption.DEFAULT);
        }
        List<String> timestampOptions = elementDisplayOption.get();
        return new TimestampElement(DateTimeFormatter.ofPattern(timestampOptions.getFirst()), TimestampElement.getTimeZoneOption(timestampOptions));
    }

    private static TimeZoneOption getTimeZoneOption(List<String> formatOptions) {
        if (formatOptions.size() == 1) {
            return TimeZoneOption.DEFAULT;
        }
        return TimeZoneOption.from(formatOptions.get(1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TimestampElement) {
            TimestampElement that = (TimestampElement)o;
            return ComparisonCopy.from(this).equals(ComparisonCopy.from(that));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ComparisonCopy.from(this));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        this.dateTimeFormatter.formatTo(logEvent.getTimestamp().atZone(this.timeZoneOption == TimeZoneOption.UTC ? ZoneOffset.UTC : ZoneId.systemDefault()), target);
    }

    static enum TimeZoneOption {
        UTC,
        DEFAULT;


        public static TimeZoneOption from(String timeZoneOption) {
            return Arrays.stream(TimeZoneOption.values()).filter(v -> v.name().equalsIgnoreCase(timeZoneOption)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown time zone option: %s. Valid options are: %s".formatted(timeZoneOption, Arrays.toString((Object[])TimeZoneOption.values()))));
        }
    }

    private record ComparisonCopy(String dateTimeFormatter, TimeZoneOption timeZoneOption) {
        public static ComparisonCopy from(TimestampElement timestampElement) {
            return new ComparisonCopy(Objects.toString(timestampElement.dateTimeFormatter), timestampElement.timeZoneOption);
        }
    }
}

