/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;

public class StackTraces {
    private StackTraces() {
    }

    public static StackWalker.StackFrame earliestCallerOfAny(Set<String> calleeClassNames) {
        List stackFrames = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(Stream::toList);
        for (int i = stackFrames.size() - 1; i >= 0; --i) {
            if (!calleeClassNames.contains(((StackWalker.StackFrame)stackFrames.get(i)).getClassName()) || i + 1 >= stackFrames.size()) continue;
            return (StackWalker.StackFrame)stackFrames.get(i + 1);
        }
        throw new NoSuchElementException(String.format("No caller found: calleeClassNames='%s', stackFrames=%s", calleeClassNames, stackFrames));
    }

    public static StringBuffer getTraceAsBuffer(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            return stringBuffer;
        }
    }
}

