/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.writer;

import com.google.common.base.Strings;
import conseq4j.execute.ConseqExecutor;
import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.NativeLogServiceManager;
import elf4j.engine.logging.PerformanceSensitive;
import elf4j.engine.logging.config.ConfigurationProperties;
import elf4j.engine.logging.writer.LogWriter;
import elf4j.engine.logging.writer.LogWriterFactory;
import elf4j.engine.logging.writer.StandardStreamWriterFactory;
import elf4j.util.UtilLogger;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.jspecify.annotations.Nullable;
import org.slf4j.MDC;

public class CompositeWriter
implements LogWriter,
NativeLogServiceManager.Stoppable {
    private static final Logger LOGGER = UtilLogger.INFO;
    private static final LogWriterFactory DEFAULT_WRITER_FACTORY = new StandardStreamWriterFactory();
    private final List<LogWriter> writers;
    private final ConseqExecutor conseqExecutor;
    private @Nullable Level thresholdOutputLevel;
    private @Nullable Boolean includeCallerDetail;

    private CompositeWriter(List<LogWriter> writers, ConseqExecutor conseqExecutor) {
        this.writers = writers;
        this.conseqExecutor = conseqExecutor;
        LOGGER.info((Object)"%s service writer(s) in %s".formatted(writers.size(), this));
        NativeLogServiceManager.INSTANCE.register(this);
    }

    public static CompositeWriter from(ConfigurationProperties configurationProperties) {
        ArrayList<LogWriterFactory> configuredWriterFactories = new ArrayList<LogWriterFactory>(CompositeWriter.getLogWriterFactories(configurationProperties));
        if (configuredWriterFactories.isEmpty()) {
            configuredWriterFactories.add(DEFAULT_WRITER_FACTORY);
        }
        List<LogWriter> logWriters = configuredWriterFactories.stream().map(logWriterFactory -> logWriterFactory.getLogWriter(configurationProperties.getProperties())).toList();
        return new CompositeWriter(logWriters, Optional.ofNullable(configurationProperties.getAsInteger("concurrency")).map(ConseqExecutor::instance).orElse(ConseqExecutor.instance()));
    }

    private static List<LogWriterFactory> getLogWriterFactories(ConfigurationProperties configurationProperties) {
        if (configurationProperties.isAbsent()) {
            return Collections.emptyList();
        }
        Properties properties = configurationProperties.getProperties();
        String writerFactoryClassNames = properties.getProperty("writer.factories");
        if (writerFactoryClassNames == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(writerFactoryClassNames.split(",")).map(String::strip).filter(strip -> !Strings.isNullOrEmpty((String)strip)).map(fqcn -> {
            try {
                return (LogWriterFactory)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Unable to construct log writer factory: fqcn='%s' - it must have a no-arg constructor and of type %s".formatted(fqcn, LogWriterFactory.class), new Object[]{e});
                throw new IllegalArgumentException("Error instantiating writer class '%s'".formatted(fqcn), e);
            }
        }).collect(Collectors.toList());
    }

    private static Runnable withMdcContext(Runnable task) {
        Map callerContext = MDC.getCopyOfContextMap();
        return () -> {
            Map<String, String> workerContext = CompositeWriter.switchContextTo(callerContext);
            MDC.setContextMap((Map)callerContext);
            try {
                task.run();
            }
            finally {
                MDC.setContextMap(workerContext);
            }
        };
    }

    private static Map<String, String> switchContextTo(Map<String, String> targetContext) {
        Map replaced = MDC.getCopyOfContextMap();
        MDC.setContextMap(targetContext);
        return replaced;
    }

    @Override
    public Level getMinimumThresholdLevel() {
        if (this.thresholdOutputLevel == null) {
            this.thresholdOutputLevel = Level.values()[this.writers.stream().mapToInt(writer -> writer.getMinimumThresholdLevel().ordinal()).min().orElseThrow(NoSuchElementException::new)];
        }
        return this.thresholdOutputLevel;
    }

    @Override
    public void write(LogEvent logEvent) {
        this.writers.forEach(writer -> this.conseqExecutor.execute(CompositeWriter.withMdcContext(() -> writer.write(logEvent)), (Object)logEvent.getCallerThread().id()));
    }

    @Override
    public boolean includeCallerDetail() {
        if (this.includeCallerDetail == null) {
            this.includeCallerDetail = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
        }
        return this.includeCallerDetail;
    }

    @Override
    public void stop() {
        if (this.conseqExecutor.isTerminated()) {
            return;
        }
        LOGGER.info((Object)"Stopping %s".formatted(this));
        this.conseqExecutor.shutdown();
        Duration timeout = Duration.ofSeconds(30L);
        try (ConseqExecutor conseqExecutor = this.conseqExecutor;){
            Awaitility.await().atMost(timeout).until(() -> ((ConseqExecutor)this.conseqExecutor).isTerminated());
            LOGGER.info((Object)"Stopped %s".formatted(this));
        }
        catch (Exception e) {
            LOGGER.warn("Writer executor %s still not terminated after %s".formatted(this.conseqExecutor, timeout), new Object[]{e});
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeWriter)) {
            return false;
        }
        CompositeWriter other = (CompositeWriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LogWriter> this$writers = this.writers;
        List<LogWriter> other$writers = other.writers;
        return !(this$writers == null ? other$writers != null : !((Object)this$writers).equals(other$writers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompositeWriter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LogWriter> $writers = this.writers;
        result = result * 59 + ($writers == null ? 43 : ((Object)$writers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CompositeWriter(writers=" + String.valueOf(this.writers) + ", conseqExecutor=" + String.valueOf(this.conseqExecutor) + ", thresholdOutputLevel=" + String.valueOf(this.thresholdOutputLevel) + ", includeCallerDetail=" + this.includeCallerDetail + ")";
    }
}

