/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.writer;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.pattern.PatternElement;
import elf4j.engine.logging.writer.LogWriter;
import elf4j.util.UtilLogger;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;

public final class StandardStreamWriter
implements LogWriter {
    static final String DEFAULT_THRESHOLD_OUTPUT_LEVEL = "trace";
    static final String DEFAULT_PATTERN = "{timestamp} {level} {logger} - {message}";
    static final OutStreamType DEFAULT_OUT_STREAM_TYPE = OutStreamType.STDOUT;
    static final String LINE_FEED = System.lineSeparator();
    private final transient StandardOutput standardOutput;
    private final Level minimumThresholdLevel;
    private final PatternElement logPattern;
    private final OutStreamType outStreamType;

    private StandardStreamWriter(Level minimumThresholdLevel, PatternElement logPattern, OutStreamType outStreamType) {
        this.minimumThresholdLevel = minimumThresholdLevel;
        this.logPattern = logPattern;
        this.outStreamType = outStreamType;
        this.standardOutput = new StandardOutput(this.outStreamType);
    }

    @Override
    public Level getMinimumThresholdLevel() {
        return this.minimumThresholdLevel;
    }

    @Override
    public void write(LogEvent logEvent) {
        if (logEvent.getLevel().compareTo((Enum)this.minimumThresholdLevel) < 0) {
            return;
        }
        StringBuilder target = new StringBuilder();
        this.logPattern.render(logEvent, target);
        byte[] bytes = target.append(LINE_FEED).toString().getBytes(StandardCharsets.UTF_8);
        this.standardOutput.write(bytes);
    }

    @Override
    public boolean includeCallerDetail() {
        return this.logPattern.includeCallerDetail();
    }

    @Generated
    public static StandardStreamWriterBuilder builder() {
        return new StandardStreamWriterBuilder();
    }

    @Generated
    public StandardOutput getStandardOutput() {
        return this.standardOutput;
    }

    @Generated
    public PatternElement getLogPattern() {
        return this.logPattern;
    }

    @Generated
    public OutStreamType getOutStreamType() {
        return this.outStreamType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardStreamWriter)) {
            return false;
        }
        StandardStreamWriter other = (StandardStreamWriter)o;
        Level this$minimumThresholdLevel = this.getMinimumThresholdLevel();
        Level other$minimumThresholdLevel = other.getMinimumThresholdLevel();
        if (this$minimumThresholdLevel == null ? other$minimumThresholdLevel != null : !this$minimumThresholdLevel.equals(other$minimumThresholdLevel)) {
            return false;
        }
        PatternElement this$logPattern = this.getLogPattern();
        PatternElement other$logPattern = other.getLogPattern();
        if (this$logPattern == null ? other$logPattern != null : !this$logPattern.equals(other$logPattern)) {
            return false;
        }
        OutStreamType this$outStreamType = this.getOutStreamType();
        OutStreamType other$outStreamType = other.getOutStreamType();
        return !(this$outStreamType == null ? other$outStreamType != null : !((Object)((Object)this$outStreamType)).equals((Object)other$outStreamType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Level $minimumThresholdLevel = this.getMinimumThresholdLevel();
        result = result * 59 + ($minimumThresholdLevel == null ? 43 : $minimumThresholdLevel.hashCode());
        PatternElement $logPattern = this.getLogPattern();
        result = result * 59 + ($logPattern == null ? 43 : $logPattern.hashCode());
        OutStreamType $outStreamType = this.getOutStreamType();
        result = result * 59 + ($outStreamType == null ? 43 : ((Object)((Object)$outStreamType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StandardStreamWriter(standardOutput=" + String.valueOf(this.getStandardOutput()) + ", minimumThresholdLevel=" + String.valueOf(this.getMinimumThresholdLevel()) + ", logPattern=" + String.valueOf(this.getLogPattern()) + ", outStreamType=" + String.valueOf((Object)this.getOutStreamType()) + ")";
    }

    static enum OutStreamType {
        STDOUT,
        STDERR;

    }

    private static final class StandardOutput {
        private static final Logger LOGGER = UtilLogger.ERROR;
        private static final Lock OUTPUT_LOCK = new ReentrantLock(false);
        private final OutputStream outputStream;

        public StandardOutput(OutStreamType outStreamType) {
            this.outputStream = switch (outStreamType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new BufferedOutputStream(new FileOutputStream(FileDescriptor.out));
                case 1 -> new BufferedOutputStream(new FileOutputStream(FileDescriptor.err));
            };
        }

        public void write(byte[] bytes) {
            OUTPUT_LOCK.lock();
            try {
                this.outputStream.write(bytes);
                this.outputStream.flush();
            }
            catch (IOException e) {
                LOGGER.error("Failed write or flush: message=%s, outputStream=%s".formatted(new String(bytes, StandardCharsets.UTF_8), this.outputStream), new Object[]{e});
            }
            finally {
                OUTPUT_LOCK.unlock();
            }
        }
    }

    @Generated
    public static class StandardStreamWriterBuilder {
        @Generated
        private Level minimumThresholdLevel;
        @Generated
        private PatternElement logPattern;
        @Generated
        private OutStreamType outStreamType;

        @Generated
        StandardStreamWriterBuilder() {
        }

        @Generated
        public StandardStreamWriterBuilder minimumThresholdLevel(Level minimumThresholdLevel) {
            this.minimumThresholdLevel = minimumThresholdLevel;
            return this;
        }

        @Generated
        public StandardStreamWriterBuilder logPattern(PatternElement logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        @Generated
        public StandardStreamWriterBuilder outStreamType(OutStreamType outStreamType) {
            this.outStreamType = outStreamType;
            return this;
        }

        @Generated
        public StandardStreamWriter build() {
            return new StandardStreamWriter(this.minimumThresholdLevel, this.logPattern, this.outStreamType);
        }

        @Generated
        public String toString() {
            return "StandardStreamWriter.StandardStreamWriterBuilder(minimumThresholdLevel=" + String.valueOf(this.minimumThresholdLevel) + ", logPattern=" + String.valueOf(this.logPattern) + ", outStreamType=" + String.valueOf((Object)this.outStreamType) + ")";
        }
    }
}

