/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.NativeLoggerFactory;
import elf4j.engine.service.LogService;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
public class NativeLogger
implements Logger {
    @NonNull
    private final String ownerClassName;
    @NonNull
    private final Level level;
    @NonNull
    private final NativeLoggerFactory nativeLoggerFactory;

    public NativeLogger(@NonNull String ownerClassName, @NonNull Level level, @NonNull NativeLoggerFactory nativeLoggerFactory) {
        if (ownerClassName == null) {
            throw new NullPointerException("ownerClassName is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (nativeLoggerFactory == null) {
            throw new NullPointerException("nativeLoggerFactory is marked non-null but is null");
        }
        this.ownerClassName = ownerClassName;
        this.level = level;
        this.nativeLoggerFactory = nativeLoggerFactory;
    }

    public NativeLogger atLevel(Level level) {
        return this.level == level ? this : this.nativeLoggerFactory.getLogger(level, this.ownerClassName);
    }

    @NonNull
    public Level getLevel() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.getLogService().isEnabled(this);
    }

    public void log(Object message) {
        this.service(null, message, null);
    }

    public void log(String message, Object ... arguments) {
        this.service(null, message, arguments);
    }

    public void log(Throwable throwable) {
        this.service(throwable, null, null);
    }

    public void log(Throwable throwable, Object message) {
        this.service(throwable, message, null);
    }

    public void log(Throwable throwable, String message, Object ... arguments) {
        this.service(throwable, message, arguments);
    }

    public LogService getLogService() {
        return this.nativeLoggerFactory.getLogService();
    }

    @NonNull
    public String getOwnerClassName() {
        return this.ownerClassName;
    }

    private void service(Throwable throwable, Object message, Object[] arguments) {
        this.getLogService().log(this, NativeLogger.class, throwable, message, arguments);
    }
}

