/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.NativeLogger;
import elf4j.engine.service.DispatchingLogService;
import elf4j.engine.service.LogService;
import elf4j.engine.service.util.StackTraceUtils;
import elf4j.spi.LoggerFactory;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class NativeLoggerFactory
implements LoggerFactory {
    private static final Level DEFAULT_LOGGER_SEVERITY_LEVEL = Level.INFO;
    @NonNull
    private final Level defaultLoggerLevel;
    private final Map<Level, Map<String, NativeLogger>> nativeLoggers;
    @NonNull
    private final Class<?> serviceAccessClass;
    @NonNull
    private final LogService logService;

    public NativeLoggerFactory() {
        this(Logger.class);
    }

    public NativeLoggerFactory(@NonNull Class<?> serviceAccessClass) {
        this(DEFAULT_LOGGER_SEVERITY_LEVEL, serviceAccessClass, new DispatchingLogService());
        if (serviceAccessClass == null) {
            throw new NullPointerException("serviceAccessClass is marked non-null but is null");
        }
    }

    NativeLoggerFactory(@NonNull Level defaultLoggerLevel, @NonNull Class<?> serviceAccessClass, @NonNull LogService logService) {
        if (defaultLoggerLevel == null) {
            throw new NullPointerException("defaultLoggerLevel is marked non-null but is null");
        }
        if (serviceAccessClass == null) {
            throw new NullPointerException("serviceAccessClass is marked non-null but is null");
        }
        if (logService == null) {
            throw new NullPointerException("logService is marked non-null but is null");
        }
        this.defaultLoggerLevel = defaultLoggerLevel;
        this.serviceAccessClass = serviceAccessClass;
        this.nativeLoggers = EnumSet.allOf(Level.class).stream().collect(Collectors.toMap(Function.identity(), level -> new ConcurrentHashMap()));
        this.logService = logService;
    }

    public NativeLogger logger() {
        return this.getLogger(this.defaultLoggerLevel, StackTraceUtils.callerOf(this.serviceAccessClass).getClassName());
    }

    @NonNull
    LogService getLogService() {
        return this.logService;
    }

    NativeLogger getLogger(Level level, String ownerClassName) {
        return this.nativeLoggers.get(level).computeIfAbsent(ownerClassName, ownerClass -> new NativeLogger((String)ownerClass, level, this));
    }
}

