/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class ClassPattern
implements LogPattern {
    private static final DisplayOption DEFAULT_DISPLAY_OPTION = DisplayOption.SIMPLE;
    @NonNull
    private final DisplayOption classDisplayOption;

    @Nonnull
    public static ClassPattern from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        if (!PatternType.CLASS.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new ClassPattern(PatternType.getPatternDisplayOption(patternSegment).map(displayOption -> DisplayOption.valueOf(displayOption.toUpperCase())).orElse(DEFAULT_DISPLAY_OPTION));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        String fullName = logEvent.getCallerClassName();
        switch (this.classDisplayOption) {
            case FULL: {
                target.append(fullName);
                return;
            }
            case SIMPLE: {
                target.append(fullName.substring(fullName.lastIndexOf(46) + 1));
                return;
            }
            case COMPRESSED: {
                String[] tokens = fullName.split("\\.");
                String simpleName = tokens[tokens.length - 1];
                for (int i = 0; i < tokens.length - 1; ++i) {
                    target.append(tokens[i].charAt(0)).append('.');
                }
                target.append(simpleName);
                return;
            }
        }
        throw new IllegalArgumentException("class display option: " + (Object)((Object)this.classDisplayOption));
    }

    public ClassPattern(@NonNull DisplayOption classDisplayOption) {
        if (classDisplayOption == null) {
            throw new NullPointerException("classDisplayOption is marked non-null but is null");
        }
        this.classDisplayOption = classDisplayOption;
    }

    @NonNull
    public DisplayOption getClassDisplayOption() {
        return this.classDisplayOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPattern)) {
            return false;
        }
        ClassPattern other = (ClassPattern)o;
        DisplayOption this$classDisplayOption = this.getClassDisplayOption();
        DisplayOption other$classDisplayOption = other.getClassDisplayOption();
        return !(this$classDisplayOption == null ? other$classDisplayOption != null : !((Object)((Object)this$classDisplayOption)).equals((Object)other$classDisplayOption));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayOption $classDisplayOption = this.getClassDisplayOption();
        result = result * 59 + ($classDisplayOption == null ? 43 : ((Object)((Object)$classDisplayOption)).hashCode());
        return result;
    }

    public String toString() {
        return "ClassPattern(classDisplayOption=" + (Object)((Object)this.getClassDisplayOption()) + ")";
    }

    static enum DisplayOption {
        FULL,
        SIMPLE,
        COMPRESSED;

    }
}

