/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class FileNamePattern
implements LogPattern {
    @Nonnull
    public static FileNamePattern from(String patternSegment) {
        if (!PatternType.FILENAME.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new FileNamePattern();
    }

    @Override
    public boolean includeCallerDetail() {
        return true;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(logEvent.getCallerDetail().getFileName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FileNamePattern;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "FileNamePattern()";
    }
}

