/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class LevelPattern
implements LogPattern {
    private static final int UNSPECIFIED = -1;
    private final int displayLength;

    private LevelPattern(int displayLength) {
        this.displayLength = displayLength;
    }

    @Nonnull
    public static LevelPattern from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        if (!PatternType.LEVEL.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new LevelPattern(PatternType.getPatternDisplayOption(patternSegment).map(Integer::parseInt).orElse(-1));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        String level = logEvent.getNativeLogger().getLevel().name();
        if (this.displayLength == -1) {
            target.append(level);
            return;
        }
        char[] levelChars = level.toCharArray();
        for (int i = 0; i < this.displayLength; ++i) {
            target.append(i < levelChars.length ? levelChars[i] : (char)' ');
        }
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelPattern)) {
            return false;
        }
        LevelPattern other = (LevelPattern)o;
        return this.getDisplayLength() == other.getDisplayLength();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDisplayLength();
        return result;
    }

    public String toString() {
        return "LevelPattern(displayLength=" + this.getDisplayLength() + ")";
    }
}

