/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import elf4j.engine.service.util.StackTraceUtils;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class MessageAndExceptionPattern
implements LogPattern {
    @Nonnull
    public static MessageAndExceptionPattern from(String patternSegment) {
        if (!PatternType.MESSAGE.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment text: " + patternSegment);
        }
        return new MessageAndExceptionPattern();
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(logEvent.getResolvedMessage());
        Throwable t = logEvent.getThrowable();
        if (t == null) {
            return;
        }
        target.append(System.lineSeparator()).append(StackTraceUtils.getTraceAsBuffer(t));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MessageAndExceptionPattern;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MessageAndExceptionPattern()";
    }
}

