/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.pattern.ClassPattern;
import elf4j.engine.service.pattern.FileNamePattern;
import elf4j.engine.service.pattern.JsonPattern;
import elf4j.engine.service.pattern.LevelPattern;
import elf4j.engine.service.pattern.LineNumberPattern;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.MessageAndExceptionPattern;
import elf4j.engine.service.pattern.MethodPattern;
import elf4j.engine.service.pattern.SystemEnvironmentPattern;
import elf4j.engine.service.pattern.SystemPropertyPattern;
import elf4j.engine.service.pattern.ThreadPattern;
import elf4j.engine.service.pattern.TimestampPattern;
import elf4j.engine.service.pattern.VerbatimPattern;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

enum PatternType {
    TIMESTAMP{

        @Override
        LogPattern translate(String patternSegment) {
            return TimestampPattern.from(patternSegment);
        }
    }
    ,
    LEVEL{

        @Override
        LogPattern translate(String patternSegment) {
            return LevelPattern.from(patternSegment);
        }
    }
    ,
    THREAD{

        @Override
        LogPattern translate(String patternSegment) {
            return ThreadPattern.from(patternSegment);
        }
    }
    ,
    CLASS{

        @Override
        LogPattern translate(String patternSegment) {
            return ClassPattern.from(patternSegment);
        }
    }
    ,
    METHOD{

        @Override
        LogPattern translate(String patternSegment) {
            return MethodPattern.from(patternSegment);
        }
    }
    ,
    FILENAME{

        @Override
        LogPattern translate(String patternSegment) {
            return FileNamePattern.from(patternSegment);
        }
    }
    ,
    LINENUMBER{

        @Override
        LogPattern translate(String patternSegment) {
            return LineNumberPattern.from(patternSegment);
        }
    }
    ,
    MESSAGE{

        @Override
        LogPattern translate(String patternSegment) {
            return MessageAndExceptionPattern.from(patternSegment);
        }
    }
    ,
    JSON{

        @Override
        LogPattern translate(String patternSegment) {
            return JsonPattern.from(patternSegment);
        }
    }
    ,
    SYSPROP{

        @Override
        LogPattern translate(String patternSegment) {
            return SystemPropertyPattern.from(patternSegment);
        }
    }
    ,
    SYSENV{

        @Override
        LogPattern translate(String patternSegment) {
            return SystemEnvironmentPattern.from(patternSegment);
        }
    }
    ,
    VERBATIM{

        @Override
        LogPattern translate(String patternSegment) {
            return VerbatimPattern.from(patternSegment);
        }
    };

    private static final EnumSet<PatternType> PATTERN_TYPES;
    private static final EnumSet<PatternType> PREDEFINED_PATTERN_TYPES;

    static Optional<String> getPatternDisplayOption(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        String[] elements = patternSegment.split(":", 2);
        return elements.length == 1 ? Optional.empty() : Optional.of(elements[1].trim());
    }

    @NonNull
    static List<LogPattern> parsePatterns(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (pattern.trim().isEmpty()) {
            throw new IllegalArgumentException("Unexpected blank pattern");
        }
        ArrayList<LogPattern> logPatterns = new ArrayList<LogPattern>();
        int length = pattern.length();
        int i = 0;
        while (i < length) {
            String segment;
            int j;
            if (pattern.charAt(i) == '{') {
                j = pattern.indexOf(125, i);
                if (j != -1) {
                    segment = pattern.substring(i + 1, j);
                    i = j + 1;
                } else {
                    segment = pattern.substring(i);
                    i = length;
                }
            } else {
                j = pattern.indexOf(123, i);
                if (j != -1) {
                    segment = pattern.substring(i, j);
                    i = j;
                } else {
                    segment = pattern.substring(i);
                    i = length;
                }
            }
            logPatterns.add(PatternType.parsePattern(segment));
        }
        return logPatterns;
    }

    private static LogPattern parsePattern(String patternSegment) {
        return PATTERN_TYPES.stream().filter(type -> type.isTargetTypeOf(patternSegment)).findFirst().orElseThrow(() -> new IllegalArgumentException("pattern segment: '" + patternSegment + "'")).translate(patternSegment);
    }

    abstract LogPattern translate(String var1);

    boolean isTargetTypeOf(String patternSegment) {
        if (this == VERBATIM) {
            return PREDEFINED_PATTERN_TYPES.stream().noneMatch(type -> type.isTargetTypeOf(patternSegment));
        }
        return this.name().equalsIgnoreCase(patternSegment.split(":", 2)[0].trim());
    }

    static {
        PATTERN_TYPES = EnumSet.allOf(PatternType.class);
        PREDEFINED_PATTERN_TYPES = EnumSet.complementOf(EnumSet.of(VERBATIM));
    }
}

