/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;

public class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Map<String, String> getChildProperties(String prefix, @NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        String start = prefix + '.';
        return properties.stringPropertyNames().stream().filter(name -> name.trim().startsWith(start)).collect(Collectors.toMap(name -> name.substring(start.length()).trim(), name -> properties.getProperty((String)name).trim()));
    }

    public static List<Map<String, String>> getPropertiesGroupOfType(String type, @NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return properties.stringPropertyNames().stream().filter(name -> properties.getProperty((String)name).trim().equals(type)).map(name -> PropertiesUtils.getChildProperties(name, properties)).collect(Collectors.toList());
    }

    @Nullable
    public static Integer getAsInteger(String name, @NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        String value = properties.getProperty(name);
        if (value == null) {
            return null;
        }
        String digits = value.replaceAll("\\D", "");
        if (digits.isEmpty()) {
            return null;
        }
        return value.startsWith("-") ? -Integer.parseInt(digits) : Integer.parseInt(digits);
    }

    public static int getIntOrDefault(String name, @NonNull Properties properties, int defaultValue) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        Integer value = PropertiesUtils.getAsInteger(name, properties);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

