/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import elf4j.engine.service.LogServiceManager;
import elf4j.engine.service.Stoppable;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.util.PropertiesUtils;
import elf4j.engine.service.writer.StandardOutput;
import elf4j.util.IeLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

public class BufferedStandardOutput
implements StandardOutput,
Stoppable {
    private static final int DEFAULT_BACK_BUFFER_CAPACITY = Integer.MAX_VALUE;
    private static final OutStreamType DEFAULT_OUT_STREAM_TYPE = OutStreamType.STDOUT;
    private final OutStreamType outStreamType;
    private final BlockingQueue<byte[]> buffer;
    private final PollingBytesWriter pollingBytesWriter;
    private boolean stopped;

    private BufferedStandardOutput(OutStreamType outStreamType, int bufferCapacity) {
        this.outStreamType = outStreamType;
        this.buffer = new LinkedBlockingQueue<byte[]>(bufferCapacity);
        this.pollingBytesWriter = new PollingBytesWriter(bufferCapacity);
        LogServiceManager.INSTANCE.registerStop(this);
        this.stopped = false;
        new Thread(this.pollingBytesWriter).start();
    }

    public static BufferedStandardOutput from(LogServiceConfiguration logServiceConfiguration) {
        Properties properties = logServiceConfiguration.getProperties();
        return new BufferedStandardOutput(BufferedStandardOutput.getOutStreamType(properties), BufferedStandardOutput.getBufferCapacity(properties));
    }

    private static int getBufferCapacity(Properties properties) {
        int bufferCapacity = PropertiesUtils.getIntOrDefault("buffer.back", properties, Integer.MAX_VALUE);
        IeLogger.INFO.log("Buffer back: {}", new Object[]{bufferCapacity});
        if (bufferCapacity < 1) {
            IeLogger.ERROR.log("Unexpected buffer.back: {}, cannot be less than 1", new Object[]{bufferCapacity});
            throw new IllegalArgumentException("buffer.back: " + bufferCapacity);
        }
        return bufferCapacity;
    }

    private static OutStreamType getOutStreamType(Properties properties) {
        String stream = properties.getProperty("stream");
        return stream == null ? DEFAULT_OUT_STREAM_TYPE : OutStreamType.valueOf(stream.toUpperCase());
    }

    @Override
    public void stop() {
        long longMinutes = 10L;
        ExecutorService shutdownThread = Executors.newSingleThreadExecutor();
        shutdownThread.execute(() -> {
            ConditionFactory await = Awaitility.with().timeout(longMinutes, TimeUnit.MINUTES).await();
            await.until(this.buffer::isEmpty);
            await.until(this.pollingBytesWriter::isBufferEmpty);
            this.stopped = true;
        });
        shutdownThread.shutdown();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void write(byte[] bytes) {
        try {
            this.buffer.put(bytes);
        }
        catch (InterruptedException e) {
            IeLogger.ERROR.log((Throwable)e, "Thread interrupted while enqueuing bytes of '{}' to standard output buffer {}", new Object[]{new String(bytes, StandardCharsets.UTF_8), this.buffer});
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return "BufferedStandardOutput(outStreamType=" + (Object)((Object)this.outStreamType) + ", buffer=" + this.buffer + ", pollingBytesWriter=" + this.pollingBytesWriter + ", stopped=" + this.isStopped() + ")";
    }

    private class PollingBytesWriter
    implements Runnable {
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final int batchSize;

        private PollingBytesWriter(int batchSize) {
            if (batchSize < 0) {
                throw new IllegalArgumentException();
            }
            this.batchSize = Math.max(1, batchSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!BufferedStandardOutput.this.stopped) {
                ByteArrayOutputStream byteArrayOutputStream = this.byteArrayOutputStream;
                synchronized (byteArrayOutputStream) {
                    this.byteArrayOutputStream.reset();
                    LinkedList pollBatch = new LinkedList();
                    BufferedStandardOutput.this.buffer.drainTo(pollBatch, this.batchSize);
                    if (pollBatch.isEmpty()) {
                        continue;
                    }
                    pollBatch.forEach(bytes -> {
                        try {
                            this.byteArrayOutputStream.write((byte[])bytes);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                    try {
                        this.byteArrayOutputStream.writeTo(BufferedStandardOutput.this.outStreamType == OutStreamType.STDERR ? System.err : System.out);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }

        public boolean isBufferEmpty() {
            return this.byteArrayOutputStream.size() == 0;
        }
    }

    static enum OutStreamType {
        STDOUT,
        STDERR;

    }
}

