/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import elf4j.Level;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.writer.LogWriter;
import elf4j.engine.service.writer.LogWriterType;
import elf4j.engine.service.writer.PerformanceSensitive;
import elf4j.engine.service.writer.StandardStreamsWriter;
import elf4j.util.IeLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import lombok.NonNull;

public class CooperatingWriterGroup
implements LogWriter {
    private final List<LogWriter> writers;
    private Level minimumLevel;
    private Boolean includeCallerDetail;
    private Boolean includeCallerThread;

    private CooperatingWriterGroup(List<LogWriter> writers) {
        this.writers = writers;
    }

    @NonNull
    public static CooperatingWriterGroup from(LogServiceConfiguration logServiceConfiguration) {
        ArrayList<LogWriterType> logWriterTypes = new ArrayList<LogWriterType>(CooperatingWriterGroup.getLogWriterTypes(logServiceConfiguration));
        if (logWriterTypes.isEmpty()) {
            logWriterTypes.add(new StandardStreamsWriter.StandardStreamsWriterType());
        }
        List<LogWriter> logWriters = logWriterTypes.stream().flatMap(t -> t.getLogWriters(logServiceConfiguration).stream()).collect(Collectors.toList());
        IeLogger.INFO.log("{} service writer(s): {}", new Object[]{logWriters.size(), logWriters});
        return new CooperatingWriterGroup(logWriters);
    }

    private static List<LogWriterType> getLogWriterTypes(LogServiceConfiguration logServiceConfiguration) {
        String writerTypes = logServiceConfiguration.getProperties().getProperty("writer.types");
        if (writerTypes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(writerTypes.split(",")).map(String::trim).map(fqcn -> {
            try {
                return (LogWriterType)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException((String)fqcn, e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Level getMinimumOutputLevel() {
        if (this.minimumLevel == null) {
            this.minimumLevel = Level.values()[this.writers.stream().mapToInt(writer -> writer.getMinimumOutputLevel().ordinal()).min().orElseThrow(NoSuchElementException::new)];
        }
        return this.minimumLevel;
    }

    @Override
    public void write(LogEvent logEvent) {
        this.writers.parallelStream().forEach(writer -> writer.write(logEvent));
    }

    @Override
    public boolean includeCallerDetail() {
        if (this.includeCallerDetail == null) {
            this.includeCallerDetail = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
        }
        return this.includeCallerDetail;
    }

    @Override
    public boolean includeCallerThread() {
        if (this.includeCallerThread == null) {
            this.includeCallerThread = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerThread);
        }
        return this.includeCallerThread;
    }

    public String toString() {
        return "CooperatingWriterGroup(writers=" + this.writers + ", minimumLevel=" + this.minimumLevel + ")";
    }
}

