/*
 * Decompiled with CFR 0.152.
 */
package com.devt.randomizer;

import com.devt.randomizer.RandomizerParameter;
import com.devt.randomizer.inventories.FieldRandomizerInventory;
import com.devt.randomizer.randomizers.Randomizer;
import com.devt.randomizer.randomizers.collections.ArrayRandomizer;
import com.devt.randomizer.randomizers.collections.ListRandomizer;
import com.devt.randomizer.randomizers.collections.MapRandomizer;
import com.devt.randomizer.randomizers.collections.SetRandomizer;
import com.devt.randomizer.randomizers.collections.StreamRandomizer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class RandomizerFactory {
    private final RandomizerParameter parameter = new RandomizerParameter();
    private final FieldRandomizerInventory fieldRandomizerInventory = new FieldRandomizerInventory(this.parameter);

    public <T> Randomizer<T> getRandomizer(Class<T> clazz) {
        return this.fieldRandomizerInventory.get(clazz);
    }

    public <T> Randomizer<List<T>> getListRandomizer(Class<T> clazz) {
        Randomizer<T> elementRandomizer = this.getRandomizer(clazz);
        return new ListRandomizer<T>(elementRandomizer, this.parameter.getCollectionSize());
    }

    public <T> Randomizer<Set<T>> getSetRandomizer(Class<T> clazz) {
        Randomizer<T> elementRandomizer = this.getRandomizer(clazz);
        return new SetRandomizer<T>(elementRandomizer, this.parameter.getCollectionSize());
    }

    public <T> Randomizer<T[]> getArrayRandomizer(Class<T> clazz) {
        Randomizer<T> elementRandomizer = this.getRandomizer(clazz);
        return new ArrayRandomizer<T>(elementRandomizer, clazz, this.parameter.getCollectionSize());
    }

    public <T> Randomizer<Stream<T>> getStreamRandomizer(Class<T> clazz) {
        Randomizer<T> elementRandomizer = this.getRandomizer(clazz);
        return new StreamRandomizer<T>(elementRandomizer, this.parameter.getCollectionSize());
    }

    public <V, K> Randomizer<Map<K, V>> getMapRandomizer(Class<K> keyClazz, Class<V> valueClazz) {
        Randomizer<K> keyRandomizer = this.getRandomizer(keyClazz);
        Randomizer<V> valueRandomizer = this.getRandomizer(valueClazz);
        return new MapRandomizer<K, V>(keyRandomizer, valueRandomizer, this.parameter.getCollectionSize());
    }
}

