/*
 * Decompiled with CFR 0.152.
 */
package com.devt.randomizer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDateTime;

public class RandomizerParameter {
    private final int stringLength;
    private final String stringCharacters;
    private final int collectionSize;
    private final int minInteger;
    private final int maxInteger;
    private final double minDouble;
    private final double maxDouble;
    private final short minShort;
    private final short maxShort;
    private final long minLong;
    private final long maxLong;
    private final float minFloat;
    private final float maxFloat;
    private final byte minByte;
    private final byte maxByte;
    private final BigInteger minBigInteger;
    private final BigInteger maxBigInteger;
    private final BigDecimal minBigDecimal;
    private final BigDecimal maxBigDecimal;
    private final int scaleBigDecimal;
    private final RoundingMode roundingModeBigDecimal;
    private final LocalDateTime fromDate;
    private final LocalDateTime toDate;

    private RandomizerParameter(Builder builder) {
        this.stringLength = builder.stringLength;
        this.stringCharacters = builder.stringCharacters;
        this.collectionSize = builder.collectionSize;
        this.minInteger = builder.minInteger;
        this.maxInteger = builder.maxInteger;
        this.minDouble = builder.minDouble;
        this.maxDouble = builder.maxDouble;
        this.minShort = builder.minShort;
        this.maxShort = builder.maxShort;
        this.minLong = builder.minLong;
        this.maxLong = builder.maxLong;
        this.minFloat = builder.minFloat;
        this.maxFloat = builder.maxFloat;
        this.minByte = builder.minByte;
        this.maxByte = builder.maxByte;
        this.minBigInteger = builder.minBigInteger;
        this.maxBigInteger = builder.maxBigInteger;
        this.minBigDecimal = builder.minBigDecimal;
        this.maxBigDecimal = builder.maxBigDecimal;
        this.scaleBigDecimal = builder.scaleBigDecimal;
        this.roundingModeBigDecimal = builder.roundingModeBigDecimal;
        this.fromDate = builder.fromDate;
        this.toDate = builder.toDate;
    }

    public RandomizerParameter() {
        this(new Builder());
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public String getStringCharacters() {
        return this.stringCharacters;
    }

    public int getCollectionSize() {
        return this.collectionSize;
    }

    public int getMinInteger() {
        return this.minInteger;
    }

    public int getMaxInteger() {
        return this.maxInteger;
    }

    public double getMinDouble() {
        return this.minDouble;
    }

    public double getMaxDouble() {
        return this.maxDouble;
    }

    public short getMinShort() {
        return this.minShort;
    }

    public short getMaxShort() {
        return this.maxShort;
    }

    public long getMinLong() {
        return this.minLong;
    }

    public long getMaxLong() {
        return this.maxLong;
    }

    public float getMinFloat() {
        return this.minFloat;
    }

    public float getMaxFloat() {
        return this.maxFloat;
    }

    public byte getMinByte() {
        return this.minByte;
    }

    public byte getMaxByte() {
        return this.maxByte;
    }

    public BigInteger getMinBigInteger() {
        return this.minBigInteger;
    }

    public BigInteger getMaxBigInteger() {
        return this.maxBigInteger;
    }

    public BigDecimal getMinBigDecimal() {
        return this.minBigDecimal;
    }

    public BigDecimal getMaxBigDecimal() {
        return this.maxBigDecimal;
    }

    public int getScaleBigDecimal() {
        return this.scaleBigDecimal;
    }

    public RoundingMode getRoundingModeBigDecimal() {
        return this.roundingModeBigDecimal;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public static class Builder {
        private int stringLength = 10;
        private String stringCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[]{}|;:'\",./<>?";
        private int collectionSize = 5;
        private int minInteger = 0;
        private int maxInteger = 100;
        private double minDouble = 0.0;
        private double maxDouble = 100.0;
        private short minShort = 0;
        private short maxShort = (short)100;
        private long minLong = 0L;
        private long maxLong = 100L;
        private float minFloat = 0.0f;
        private float maxFloat = 100.0f;
        private byte minByte = (byte)-128;
        private byte maxByte = (byte)127;
        private BigInteger minBigInteger = BigInteger.ZERO;
        private BigInteger maxBigInteger = BigInteger.valueOf(100L);
        private BigDecimal minBigDecimal = BigDecimal.ZERO;
        private BigDecimal maxBigDecimal = BigDecimal.valueOf(100.0);
        private int scaleBigDecimal = 2;
        private RoundingMode roundingModeBigDecimal = RoundingMode.HALF_UP;
        private LocalDateTime fromDate = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
        private LocalDateTime toDate = LocalDateTime.of(2030, 12, 31, 23, 59, 59);

        public Builder withDateRange(LocalDateTime fromDate, LocalDateTime toDate) {
            this.fromDate = fromDate;
            this.toDate = toDate;
            return this;
        }

        public Builder withBigDecimal(BigDecimal minBigDecimal, BigDecimal maxBigDecimal, int scaleBigDecimal, RoundingMode roundingModeBigDecimal) {
            this.minBigDecimal = minBigDecimal;
            this.maxBigDecimal = maxBigDecimal;
            this.scaleBigDecimal = scaleBigDecimal;
            this.roundingModeBigDecimal = roundingModeBigDecimal;
            return this;
        }

        public Builder withBigInteger(BigInteger min, BigInteger max) {
            this.minBigInteger = min;
            this.maxBigInteger = max;
            return this;
        }

        public Builder withByte(byte min, byte max) {
            this.minByte = min;
            this.maxByte = max;
            return this;
        }

        public Builder withShort(short min, short max) {
            this.minShort = min;
            this.maxShort = max;
            return this;
        }

        public Builder withLong(long min, long max) {
            this.minLong = min;
            this.maxLong = max;
            return this;
        }

        public Builder withFloat(float min, float max) {
            this.minFloat = min;
            this.maxFloat = max;
            return this;
        }

        public Builder withInteger(int min, int max) {
            this.minInteger = min;
            this.maxInteger = max;
            return this;
        }

        public Builder withDouble(double min, double max) {
            this.minDouble = min;
            this.maxDouble = max;
            return this;
        }

        public Builder withString(int length, String characters) {
            this.stringLength = length;
            this.stringCharacters = characters;
            return this;
        }

        public Builder withCollection(int size) {
            this.collectionSize = size;
            return this;
        }

        public RandomizerParameter build() {
            return new RandomizerParameter(this);
        }
    }
}

