/*
 * Decompiled with CFR 0.152.
 */
package com.devt.randomizer.inventories;

import com.devt.randomizer.RandomizerParameter;
import com.devt.randomizer.randomizers.Randomizer;
import com.devt.randomizer.randomizers.fields.dates.DateRandomizer;
import com.devt.randomizer.randomizers.fields.dates.InstantRandomizer;
import com.devt.randomizer.randomizers.fields.dates.LocalDateRandomizer;
import com.devt.randomizer.randomizers.fields.dates.LocalDateTimeRandomizer;
import com.devt.randomizer.randomizers.fields.dates.LocalTimeRandomizer;
import com.devt.randomizer.randomizers.fields.dates.OffsetDateTimeRandomizer;
import com.devt.randomizer.randomizers.fields.dates.OffsetTimeRandomizer;
import com.devt.randomizer.randomizers.fields.dates.SqlDateRandomizer;
import com.devt.randomizer.randomizers.fields.dates.ZonedDateTimeRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.BigDecimalRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.BigIntegerRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.DoubleRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.FloatRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.IntegerRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.LongRandomizer;
import com.devt.randomizer.randomizers.fields.numbers.ShortRandomizer;
import com.devt.randomizer.randomizers.fields.types.BooleanRandomizer;
import com.devt.randomizer.randomizers.fields.types.ByteRandomizer;
import com.devt.randomizer.randomizers.fields.types.CharacterRandomizer;
import com.devt.randomizer.randomizers.fields.types.EnumRandomizer;
import com.devt.randomizer.randomizers.fields.types.StringRandomizer;
import com.devt.randomizer.randomizers.fields.types.UUIDRandomizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FieldRandomizerInventory {
    protected final Map<Class<?>, Randomizer<?>> randomizers;
    private final RandomizerParameter parameter;

    public FieldRandomizerInventory(RandomizerParameter parameter) {
        this.parameter = parameter;
        this.randomizers = new HashMap();
        this.registerStringRandomizer();
        this.registerBooleanRandomizer();
        this.registerDoubleRandomizer();
        this.registerIntegerRandomizer();
        this.registerShortRandomizer();
        this.registerLongRandomizer();
        this.registerFloatRandomizer();
        this.registerBigDecimalRandomizer();
        this.registerBigIntegerRandomizer();
        this.registerByteRandomizer();
        this.registerCharacterRandomizer();
        this.registerUUIDRandomizer();
        this.registerDateRandomizer();
        this.registerInstantRandomizer();
        this.registerLocalDateRandomizer();
        this.registerLocalDateTimeRandomizer();
        this.registerLocalTimeRandomizer();
        this.registerOffsetTimeRandomizer();
        this.registerOffsetDateTimeRandomizer();
        this.registerSqlDateRandomizer();
        this.registerZonedDateTimeRandomizer();
    }

    public <T> Randomizer<T> get(Class<T> clazz) {
        Randomizer<?> randomizer = this.randomizers.get(clazz);
        if (randomizer != null) {
            return randomizer;
        }
        if (clazz.isEnum()) {
            return this.registerEnum(clazz.asSubclass(Enum.class));
        }
        throw new UnsupportedOperationException("'%s' is not a supported field".formatted(clazz.getName()));
    }

    private <T extends Enum<T>> Randomizer<T> registerEnum(Class<T> enumClazz) {
        EnumRandomizer<T> enumRandomizer = new EnumRandomizer<T>(enumClazz);
        this.randomizers.put(enumClazz, enumRandomizer);
        return enumRandomizer;
    }

    private void registerStringRandomizer() {
        StringRandomizer randomizer = new StringRandomizer(this.parameter.getStringLength(), this.parameter.getStringCharacters());
        this.randomizers.put(String.class, randomizer);
    }

    private void registerBooleanRandomizer() {
        BooleanRandomizer randomizer = new BooleanRandomizer();
        this.randomizers.put(Boolean.class, randomizer);
        this.randomizers.put(Boolean.TYPE, randomizer);
    }

    private void registerCharacterRandomizer() {
        CharacterRandomizer randomizer = new CharacterRandomizer();
        this.randomizers.put(Character.class, randomizer);
        this.randomizers.put(Character.TYPE, randomizer);
    }

    private void registerByteRandomizer() {
        ByteRandomizer randomizer = new ByteRandomizer(this.parameter.getMinByte(), this.parameter.getMaxByte());
        this.randomizers.put(Byte.class, randomizer);
        this.randomizers.put(Byte.TYPE, randomizer);
    }

    private void registerDoubleRandomizer() {
        DoubleRandomizer randomizer = new DoubleRandomizer(this.parameter.getMinDouble(), this.parameter.getMaxDouble());
        this.randomizers.put(Double.class, randomizer);
        this.randomizers.put(Double.TYPE, randomizer);
    }

    private void registerIntegerRandomizer() {
        IntegerRandomizer randomizer = new IntegerRandomizer(this.parameter.getMinInteger(), this.parameter.getMaxInteger());
        this.randomizers.put(Integer.class, randomizer);
        this.randomizers.put(Integer.TYPE, randomizer);
    }

    private void registerShortRandomizer() {
        ShortRandomizer randomizer = new ShortRandomizer(this.parameter.getMinShort(), this.parameter.getMaxShort());
        this.randomizers.put(Short.class, randomizer);
        this.randomizers.put(Short.TYPE, randomizer);
    }

    private void registerLongRandomizer() {
        LongRandomizer randomizer = new LongRandomizer(this.parameter.getMinLong(), this.parameter.getMaxLong());
        this.randomizers.put(Long.class, randomizer);
        this.randomizers.put(Long.TYPE, randomizer);
    }

    private void registerFloatRandomizer() {
        FloatRandomizer randomizer = new FloatRandomizer(this.parameter.getMinFloat(), this.parameter.getMaxFloat());
        this.randomizers.put(Float.class, randomizer);
        this.randomizers.put(Float.TYPE, randomizer);
    }

    private void registerBigDecimalRandomizer() {
        BigDecimalRandomizer randomizer = new BigDecimalRandomizer(this.parameter.getMinBigDecimal(), this.parameter.getMaxBigDecimal(), this.parameter.getScaleBigDecimal(), this.parameter.getRoundingModeBigDecimal());
        this.randomizers.put(BigDecimal.class, randomizer);
    }

    private void registerBigIntegerRandomizer() {
        BigIntegerRandomizer randomizer = new BigIntegerRandomizer(this.parameter.getMinBigInteger(), this.parameter.getMaxBigInteger());
        this.randomizers.put(BigInteger.class, randomizer);
    }

    private void registerUUIDRandomizer() {
        UUIDRandomizer randomizer = new UUIDRandomizer();
        this.randomizers.put(UUID.class, randomizer);
    }

    private void registerZonedDateTimeRandomizer() {
        ZonedDateTimeRandomizer randomizer = new ZonedDateTimeRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(ZonedDateTime.class, randomizer);
    }

    private void registerSqlDateRandomizer() {
        SqlDateRandomizer randomizer = new SqlDateRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(Date.class, randomizer);
    }

    private void registerOffsetDateTimeRandomizer() {
        OffsetDateTimeRandomizer randomizer = new OffsetDateTimeRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(OffsetDateTime.class, randomizer);
    }

    private void registerOffsetTimeRandomizer() {
        OffsetTimeRandomizer randomizer = new OffsetTimeRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(OffsetTime.class, randomizer);
    }

    private void registerLocalTimeRandomizer() {
        LocalTimeRandomizer randomizer = new LocalTimeRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(LocalTime.class, randomizer);
    }

    private void registerLocalDateTimeRandomizer() {
        LocalDateTimeRandomizer randomizer = new LocalDateTimeRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(LocalDateTime.class, randomizer);
    }

    private void registerLocalDateRandomizer() {
        LocalDateRandomizer randomizer = new LocalDateRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(LocalDate.class, randomizer);
    }

    private void registerInstantRandomizer() {
        InstantRandomizer randomizer = new InstantRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(Instant.class, randomizer);
    }

    private void registerDateRandomizer() {
        DateRandomizer randomizer = new DateRandomizer(this.parameter.getFromDate(), this.parameter.getToDate());
        this.randomizers.put(java.util.Date.class, randomizer);
    }
}

