/*
 * Decompiled with CFR 0.152.
 */
package com.devt.randomizer.randomizers.fields.numbers;

import com.devt.randomizer.randomizers.Randomizer;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class FloatRandomizer
implements Randomizer<Float> {
    private final float min;
    private final float max;

    public FloatRandomizer(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("Float randomizer failed initializing, because min '%s' should be less than or equal to max '%s'".formatted(Float.valueOf(min), Float.valueOf(max)));
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public Float next() {
        if (Objects.equals(Float.valueOf(this.min), Float.valueOf(this.max))) {
            return Float.valueOf(this.min);
        }
        return Float.valueOf(this.min + ThreadLocalRandom.current().nextFloat() * (this.max - this.min));
    }
}

