/*
 * Decompiled with CFR 0.152.
 */
package com.devt.randomizer.randomizers.fields.types;

import com.devt.randomizer.randomizers.Randomizer;
import java.util.concurrent.ThreadLocalRandom;

public class EnumRandomizer<T extends Enum<T>>
implements Randomizer<T> {
    private final T[] values;

    public EnumRandomizer(Class<T> enumClass) {
        if (((Enum[])enumClass.getEnumConstants()).length == 0) {
            throw new IllegalArgumentException("Enum randomizer failed initializing for '%s', because it does not contains any value".formatted(enumClass.getSimpleName()));
        }
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    @Override
    public T next() {
        int index = ThreadLocalRandom.current().nextInt(this.values.length);
        return this.values[index];
    }
}

