/*
 * Decompiled with CFR 0.152.
 */
package elki.classification;

import elki.classification.AbstractClassifier;
import elki.data.ClassLabel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;

@Title(value="Prior Probability Classifier")
@Description(value="Classifier to predict simply prior probabilities for all classes as defined by their relative abundance in a given database.")
public class PriorProbabilityClassifier
extends AbstractClassifier<Object, Void> {
    protected double[] distribution;
    protected ClassLabel prediction;
    protected ArrayList<ClassLabel> labels;

    @Override
    public void buildClassifier(Database database, Relation<? extends ClassLabel> labelrep) {
        Object2IntOpenHashMap count = new Object2IntOpenHashMap();
        DBIDIter iter = labelrep.iterDBIDs();
        while (iter.valid()) {
            count.addTo((Object)((ClassLabel)labelrep.get((DBIDRef)iter)), 1);
            iter.advance();
        }
        int max = Integer.MIN_VALUE;
        double size = labelrep.size();
        this.distribution = new double[count.size()];
        this.labels = new ArrayList(count.size());
        ObjectIterator iter2 = count.object2IntEntrySet().fastIterator();
        int i = 0;
        while (iter2.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iter2.next();
            this.distribution[i] = (double)entry.getIntValue() / size;
            this.labels.add((ClassLabel)entry.getKey());
            if (entry.getIntValue() > max) {
                max = entry.getIntValue();
                this.prediction = (ClassLabel)entry.getKey();
            }
            ++i;
        }
    }

    public double[] classProbabilities(Object instance, ArrayList<ClassLabel> labels) {
        return this.alignLabels(this.labels, this.distribution, labels);
    }

    @Override
    public ClassLabel classify(Object instance) {
        return this.prediction;
    }

    @Override
    public String model() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.distribution.length; ++i) {
            output.append(this.labels.get(i));
            output.append(" : ");
            output.append(this.distribution[i]);
            output.append('\n');
        }
        return output.toString();
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.ANY});
    }
}

