/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.classification;

import elki.data.ClassLabel;
import java.text.NumberFormat;
import java.util.ArrayList;

public class ConfusionMatrix {
    private int[][] confusion;
    private ArrayList<ClassLabel> labels;

    public ConfusionMatrix(ArrayList<ClassLabel> labels, int[][] confusion) throws IllegalArgumentException {
        for (int i = 0; i < confusion.length; ++i) {
            if (confusion.length == confusion[i].length) continue;
            throw new IllegalArgumentException("Confusion matrix irregular: row-dimension = " + confusion.length + ", col-dimension in col" + i + " = " + confusion[i].length);
        }
        if (confusion.length != labels.size()) {
            throw new IllegalArgumentException("Number of class labels does not match row dimension of confusion matrix.");
        }
        this.confusion = confusion;
        this.labels = labels;
    }

    public double truePositiveRate() {
        return (double)this.truePositives() / (double)this.totalInstances();
    }

    public double falsePositiveRate(int classindex) {
        int fp = this.falsePositives(classindex);
        int tn = this.trueNegatives(classindex);
        return (double)fp / (double)(fp + tn);
    }

    public double falsePositiveRate() {
        double fpr = 0.0;
        for (int i = 0; i < this.confusion.length; ++i) {
            fpr += this.falsePositiveRate(i) * (double)this.colSum(i);
        }
        return fpr / (double)this.totalInstances();
    }

    public double positivePredictedValue(int classindex) {
        int tp = this.truePositives(classindex);
        return (double)tp / (double)(tp + this.falsePositives(classindex));
    }

    public double positivePredictedValue() {
        double ppv = 0.0;
        for (int i = 0; i < this.confusion.length; ++i) {
            ppv += this.positivePredictedValue(i) * (double)this.colSum(i);
        }
        return ppv / (double)this.totalInstances();
    }

    public int truePositives() {
        int tp = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            tp += this.truePositives(i);
        }
        return tp;
    }

    public int truePositives(int classindex) {
        return this.confusion[classindex][classindex];
    }

    public double truePositiveRate(int classindex) {
        int tp = this.truePositives(classindex);
        return (double)tp / (double)(tp + this.falseNegatives(classindex));
    }

    public int trueNegatives(int classindex) {
        int tn = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                if (i == classindex || j == classindex) continue;
                tn += this.confusion[i][j];
            }
        }
        return tn;
    }

    public int falsePositives(int classindex) {
        int fp = 0;
        for (int i = 0; i < this.confusion[classindex].length; ++i) {
            if (i == classindex) continue;
            fp += this.confusion[classindex][i];
        }
        return fp;
    }

    public int falseNegatives(int classindex) {
        int fn = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            if (i == classindex) continue;
            fn += this.confusion[i][classindex];
        }
        return fn;
    }

    public int totalInstances() {
        int total = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                total += this.confusion[i][j];
            }
        }
        return total;
    }

    public int rowSum(int classindex) {
        int s = 0;
        for (int i = 0; i < this.confusion[classindex].length; ++i) {
            s += this.confusion[classindex][i];
        }
        return s;
    }

    public int colSum(int classindex) {
        int s = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            s += this.confusion[i][classindex];
        }
        return s;
    }

    public int value(int trueClassindex, int predictedClassindex) {
        return this.confusion[predictedClassindex][trueClassindex];
    }

    public String toString() {
        int max = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                if (this.confusion[i][j] <= max) continue;
                max = this.confusion[i][j];
            }
        }
        String classPrefix = "C_";
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        int labelLength = Integer.toString(this.labels.size()).length();
        nf.setMaximumIntegerDigits(labelLength);
        nf.setMinimumIntegerDigits(labelLength);
        int cell = Math.max(Integer.toString(max).length(), labelLength + classPrefix.length());
        String separator = " ";
        StringBuilder representation = new StringBuilder();
        for (int i = 1; i <= this.labels.size(); ++i) {
            representation.append(separator);
            String label = classPrefix + nf.format(i);
            int space = cell - labelLength - classPrefix.length();
            for (int s = 0; s <= space; ++s) {
                representation.append(' ');
            }
            representation.append(label);
        }
        representation.append('\n');
        for (int row = 0; row < this.confusion.length; ++row) {
            for (int col = 0; col < this.confusion[row].length; ++col) {
                representation.append(separator);
                String entry = Integer.toString(this.confusion[row][col]);
                int space = cell - entry.length();
                for (int s = 0; s <= space; ++s) {
                    representation.append(' ');
                }
                representation.append(entry);
            }
            representation.append(separator);
            representation.append(classPrefix);
            representation.append(nf.format(row + 1));
            representation.append(": ");
            representation.append(this.labels.get(row));
            representation.append('\n');
        }
        return representation.toString();
    }
}

