/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.classification.holdout;

import elki.data.ClassLabel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.evaluation.classification.holdout.Holdout;
import elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public abstract class AbstractHoldout
implements Holdout {
    protected ArrayList<ClassLabel> labels;
    protected int labelcol;
    protected MultipleObjectsBundle bundle;

    @Override
    public void initialize(MultipleObjectsBundle bundle) {
        this.bundle = bundle;
        this.labelcol = AbstractHoldout.findClassLabelColumn(bundle);
        this.labels = AbstractHoldout.allClassLabels(bundle);
    }

    @Override
    public ArrayList<ClassLabel> getLabels() {
        return this.labels;
    }

    public static int findClassLabelColumn(MultipleObjectsBundle bundle) {
        int l = bundle.metaLength();
        for (int i = 0; i < l; ++i) {
            if (!TypeUtil.CLASSLABEL.isAssignableFromType((TypeInformation)bundle.meta(i))) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<ClassLabel> allClassLabels(MultipleObjectsBundle bundle) {
        int col = AbstractHoldout.findClassLabelColumn(bundle);
        if (col < 0) {
            throw new AbortException("No class label found (try using ClassLabelFilter).");
        }
        return AbstractHoldout.allClassLabels(bundle, col);
    }

    public static ArrayList<ClassLabel> allClassLabels(MultipleObjectsBundle bundle, int col) {
        HashSet<ClassLabel> labels = new HashSet<ClassLabel>();
        int l = bundle.dataLength();
        for (int i = 0; i < l; ++i) {
            Object o = bundle.data(i, col);
            if (o == null || !(o instanceof ClassLabel)) continue;
            labels.add((ClassLabel)o);
        }
        ArrayList<ClassLabel> ret = new ArrayList<ClassLabel>(labels);
        Collections.sort(ret);
        return ret;
    }
}

