/*
 * This file is part of ELKI:
 * Environment for Developing KDD-Applications Supported by Index-Structures
 *
 * Copyright (C) 2022
 * ELKI Development Team
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package elki.clustering;

import elki.Algorithm;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.database.Database;

/**
 * Interface for Algorithms that are capable to provide a {@link Clustering
 * Clustering} as Result. in general, clustering algorithms are supposed to
 * implement the {@link elki.Algorithm}-Interface. The
 * more specialized interface {@link ClusteringAlgorithm} requires an
 * implementing algorithm to provide a special result class suitable as a
 * partitioning of the database. More relaxed clustering algorithms are allowed
 * to provide a result that is a fuzzy clustering, does not partition the
 * database complete or is in any other sense a relaxed clustering result.
 *
 * @author Arthur Zimek
 * @since 0.1
 *
 * @opt operations
 * @assoc - produces - Clustering
 * @assoc - - - Model
 *
 * @param <C> Clustering type
 */
public interface ClusteringAlgorithm<C extends Clustering<? extends Model>> extends Algorithm {
  @SuppressWarnings("unchecked")
  @Override
  default C autorun(Database database) {
    return (C) Algorithm.Utils.autorun(this, database);
  }
}
