/*
 * This file is part of ELKI:
 * Environment for Developing KDD-Applications Supported by Index-Structures
 *
 * Copyright (C) 2022
 * ELKI Development Team
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package elki.clustering.kmedoids.initialization;

import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;

/**
 * Interface for initializing K-Medoids. In contrast to k-means initializers,
 * this initialization will only return members of the original data set.
 * 
 * @author Erich Schubert
 * @since 0.5.0
 * 
 * @param <O> Object type
 */
public interface KMedoidsInitialization<O> {
  /**
   * Choose initial means
   * 
   * @param k Parameter k
   * @param ids Candidate IDs.
   * @param distance Distance function
   * @return List of chosen means for k-means
   */
  DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distance);
}
