/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.SimplePrototypeModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DBIDDataStore;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.PrioritySearcher;
import elki.database.query.QueryBuilder;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.datastructures.heap.DoubleMinHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Comparator;

@Reference(authors="A. Rodriguez and A. Laio", title="Clustering by fast search and find of density peaks", booktitle="Science 344 (6191)", url="https://doi.org/10.1126/science.1242072", bibkey="doi:10.1126/science.1242072")
public class CFSFDP<O>
implements ClusteringAlgorithm<Clustering<SimplePrototypeModel<DBID>>> {
    private static final Logging LOG = Logging.getLogger(CFSFDP.class);
    protected Distance<? super O> distance;
    protected double dc;
    protected int k;

    protected CFSFDP(Distance<? super O> distance, double dc, int k) {
        this.distance = distance;
        this.dc = dc;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public Clustering<SimplePrototypeModel<DBID>> run(Relation<O> relation) {
        PrioritySearcher searcher = new QueryBuilder(relation, this.distance).priorityByDBID();
        DBIDs ids = relation.getDBIDs();
        WritableIntegerDataStore density = DataStoreFactory.FACTORY.makeIntegerStorage(ids, 3);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Density estimation", ids.size(), LOG) : null;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            int found = 0;
            searcher.search((Object)it, this.dc);
            while (searcher.valid()) {
                if (searcher.getUpperBound() <= this.dc || searcher.computeExactDistance() <= this.dc) {
                    ++found;
                }
                searcher.advance();
            }
            density.put((DBIDRef)it, found);
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore nextdist = DataStoreFactory.FACTORY.makeDoubleStorage(ids, 1);
        WritableDBIDDataStore nextn = DataStoreFactory.FACTORY.makeDBIDStorage(ids, 1);
        FiniteProgress nprog = LOG.isVerbose() ? new FiniteProgress("Finding next denser neighbor", ids.size(), LOG) : null;
        DBIDVar tmp = DBIDUtil.newVar();
        DoubleMinHeap heap = new DoubleMinHeap(this.k);
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            int dens = density.intValue((DBIDRef)it2);
            double dist = Double.POSITIVE_INFINITY;
            tmp.unset();
            searcher.search((Object)it2);
            while (searcher.valid()) {
                if (density.intValue((DBIDRef)searcher) > dens) {
                    double d;
                    double d2 = searcher.computeExactDistance();
                    if (d < dist) {
                        dist = d2;
                        tmp.set((DBIDRef)searcher.decreaseCutoff(dist));
                    }
                }
                searcher.advance();
            }
            nextdist.put((DBIDRef)it2, dist);
            nextn.put((DBIDRef)it2, (DBIDRef)tmp);
            heap.add(dist * (double)dens, this.k);
            LOG.incrementProcessed((AbstractProgress)nprog);
            it2.advance();
        }
        LOG.ensureCompleted(nprog);
        double gammathreshold = heap.peek();
        ArrayModifiableDBIDs sorted = DBIDUtil.newArray((DBIDs)ids);
        sorted.sort((Comparator)new DataStoreUtil.DescendingByIntegerDataStore((IntegerDataStore)density));
        WritableDataStore cluster = DataStoreFactory.FACTORY.makeStorage(ids, 1, ArrayModifiableDBIDs.class);
        Clustering<SimplePrototypeModel<DBID>> clustering = new Clustering<SimplePrototypeModel<DBID>>();
        FiniteProgress cprog = LOG.isVerbose() ? new FiniteProgress("Finding next denser neighbor", ids.size(), LOG) : null;
        DBIDArrayMIter it3 = sorted.iter();
        while (it3.valid()) {
            ArrayModifiableDBIDs c;
            double gamma = (double)density.intValue((DBIDRef)it3) * nextdist.doubleValue((DBIDRef)it3);
            ArrayModifiableDBIDs arrayModifiableDBIDs = c = gamma >= gammathreshold ? null : (ArrayModifiableDBIDs)cluster.get((DBIDRef)tmp.from((DBIDDataStore)nextn, (DBIDRef)it3));
            if (c == null) {
                c = DBIDUtil.newArray();
                clustering.addToplevelCluster(new Cluster<SimplePrototypeModel<DBID>>((DBIDs)c, new SimplePrototypeModel<DBID>(DBIDUtil.deref((DBIDRef)it3))));
            }
            c.add((DBIDRef)it3);
            cluster.put((DBIDRef)it3, (Object)c);
            LOG.incrementProcessed((AbstractProgress)cprog);
            it3.advance();
        }
        LOG.ensureCompleted(cprog);
        Metadata.of(clustering).setLongName("CFSFDP clustering");
        return clustering;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID DC_ID = new OptionID("cfsfdp.dc", "Distance cutoff for density estimation");
        public static final OptionID K_ID = new OptionID("cfsfdp.k", "Extract the top k clusters by gamma (on ties, there may be more).");
        protected Distance<? super O> distance;
        protected double dc;
        protected int k;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(DC_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.dc = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public CFSFDP<O> make() {
            return new CFSFDP<O>(this.distance, this.dc, this.k);
        }
    }
}

