/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering;

import elki.database.datastore.IntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;

public final class ClusteringAlgorithmUtil {
    private ClusteringAlgorithmUtil() {
    }

    public static ArrayModifiableDBIDs[] partitionsFromIntegerLabels(DBIDs ids, IntegerDataStore assignment, int k) {
        int[] sizes = new int[k];
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            int n = assignment.intValue((DBIDRef)iter);
            sizes[n] = sizes[n] + 1;
            iter.advance();
        }
        ArrayModifiableDBIDs[] clusters = new ArrayModifiableDBIDs[k];
        for (int i = 0; i < k; ++i) {
            clusters[i] = DBIDUtil.newArray((int)sizes[i]);
        }
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            clusters[assignment.intValue((DBIDRef)iter2)].add((DBIDRef)iter2);
            iter2.advance();
        }
        return clusters;
    }
}

