/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.PrototypeModel;
import elki.data.model.SimplePrototypeModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="J. A. Hartigan", title="Chapter 3: Quick Partition Algorithms, 3.2 Leader Algorithm", booktitle="Clustering algorithms", url="http://dl.acm.org/citation.cfm?id=540298", bibkey="books/wiley/Hartigan75/C3")
public class Leader<O>
implements ClusteringAlgorithm<Clustering<PrototypeModel<O>>> {
    private static final Logging LOG = Logging.getLogger(Leader.class);
    protected Distance<? super O> distance;
    protected double threshold;

    public Leader(Distance<? super O> distance, double threshold) {
        this.distance = distance;
        this.threshold = threshold;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public Clustering<PrototypeModel<O>> run(Relation<O> relation) {
        RangeSearcher rq = new QueryBuilder(relation, this.distance).rangeByDBID(this.threshold);
        HashSetModifiableDBIDs seen = DBIDUtil.newHashSet((int)relation.size());
        Clustering<PrototypeModel<O>> clustering = new Clustering<PrototypeModel<O>>();
        Metadata.of(clustering).setLongName("Leader Clustering");
        int queries = 0;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Leader clustering", relation.size(), LOG) : null;
        DBIDIter it = relation.iterDBIDs();
        while (it.valid() && seen.size() < relation.size()) {
            if (!seen.contains((DBIDRef)it)) {
                DoubleDBIDList res = rq.getRange((Object)it, this.threshold);
                ++queries;
                ArrayModifiableDBIDs ids = DBIDUtil.newArray((int)res.size());
                DoubleDBIDListIter cand = res.iter();
                while (cand.valid()) {
                    if (seen.add((DBIDRef)cand)) {
                        LOG.incrementProcessed((AbstractProgress)prog);
                        ids.add((DBIDRef)cand);
                    }
                    cand.advance();
                }
                assert (ids.size() > 0 && ids.contains((DBIDRef)it));
                SimplePrototypeModel<Object> mod = new SimplePrototypeModel<Object>(relation.get((DBIDRef)it));
                clustering.addToplevelCluster(new Cluster<SimplePrototypeModel<Object>>((DBIDs)ids, mod));
            }
            it.advance();
        }
        LOG.statistics((Statistic)new LongStatistic(this.getClass().getName() + ".queries", (long)queries));
        LOG.ensureCompleted(prog);
        return clustering;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID THRESHOLD_ID = new OptionID("leader.threshold", "Maximum distance from leading object.");
        private double threshold;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(THRESHOLD_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.threshold = x;
            });
        }

        public Leader<O> make() {
            return new Leader<O>(this.distance, this.threshold);
        }
    }
}

