/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering;

import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.result.Metadata;
import elki.similarity.SharedNearestNeighborSimilarity;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Title(value="SNN: Shared Nearest Neighbor Clustering")
@Description(value="Algorithm to find shared-nearest-neighbors-density-connected sets in a database based on the parameters 'minPts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="L. Ert\u00f6z, M. Steinbach, V. Kumar", title="Finding Clusters of Different Sizes, Shapes, and Densities in Noisy, High Dimensional Data", booktitle="Proc. of SIAM Data Mining (SDM'03)", url="https://doi.org/10.1137/1.9781611972733.5", bibkey="DBLP:conf/sdm/ErtozSK03")
public class SNNClustering<O>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(SNNClustering.class);
    private int epsilon;
    private int minpts;
    protected List<ModifiableDBIDs> resultList;
    protected ModifiableDBIDs noise;
    protected ModifiableDBIDs processedIDs;
    private SharedNearestNeighborSimilarity<O> similarityFunction;

    public SNNClustering(SharedNearestNeighborSimilarity<O> similarityFunction, int epsilon, int minpts) {
        this.similarityFunction = similarityFunction;
        this.epsilon = epsilon;
        this.minpts = minpts;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.similarityFunction.getInputTypeRestriction()});
    }

    public Clustering<Model> run(Relation<O> relation) {
        SharedNearestNeighborSimilarity.Instance snnInstance = this.similarityFunction.instantiate(relation);
        FiniteProgress objprog = LOG.isVerbose() ? new FiniteProgress("SNNClustering", relation.size(), LOG) : null;
        IndefiniteProgress clusprog = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters", LOG) : null;
        this.resultList = new ArrayList<ModifiableDBIDs>();
        this.noise = DBIDUtil.newHashSet();
        this.processedIDs = DBIDUtil.newHashSet((int)relation.size());
        if (relation.size() >= this.minpts) {
            DBIDIter id = relation.iterDBIDs();
            while (id.valid()) {
                if (!this.processedIDs.contains((DBIDRef)id)) {
                    this.expandCluster((SimilarityQuery<O>)snnInstance, (DBIDRef)id, objprog, clusprog);
                    if (this.processedIDs.size() == relation.size() && this.noise.size() == 0) break;
                }
                if (objprog != null && clusprog != null) {
                    objprog.setProcessed(this.processedIDs.size(), LOG);
                    clusprog.setProcessed(this.resultList.size(), LOG);
                }
                id.advance();
            }
        } else {
            this.noise.addDBIDs(relation.getDBIDs());
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.noise.size(), LOG);
                clusprog.setProcessed(this.resultList.size(), LOG);
            }
        }
        LOG.ensureCompleted(objprog);
        LOG.setCompleted(clusprog);
        Clustering<Model> result = new Clustering<Model>();
        Metadata.of(result).setLongName("Shared-Nearest-Neighbor Clustering");
        Iterator<ModifiableDBIDs> resultListIter = this.resultList.iterator();
        while (resultListIter.hasNext()) {
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)resultListIter.next(), ClusterModel.CLUSTER));
        }
        result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)this.noise, true, ClusterModel.CLUSTER));
        return result;
    }

    protected ArrayModifiableDBIDs findSNNNeighbors(SimilarityQuery<O> snnInstance, DBIDRef queryObject) {
        ArrayModifiableDBIDs neighbors = DBIDUtil.newArray();
        DBIDIter iditer = snnInstance.getRelation().iterDBIDs();
        while (iditer.valid()) {
            if (snnInstance.similarity(queryObject, (DBIDRef)iditer) >= (double)this.epsilon) {
                neighbors.add((DBIDRef)iditer);
            }
            iditer.advance();
        }
        return neighbors;
    }

    protected void expandCluster(SimilarityQuery<O> snnInstance, DBIDRef startObjectID, FiniteProgress objprog, IndefiniteProgress clusprog) {
        ArrayModifiableDBIDs seeds = this.findSNNNeighbors(snnInstance, startObjectID);
        if (seeds.size() < this.minpts) {
            this.noise.add(startObjectID);
            this.processedIDs.add(startObjectID);
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.processedIDs.size(), LOG);
                clusprog.setProcessed(this.resultList.size(), LOG);
            }
            return;
        }
        ArrayModifiableDBIDs currentCluster = DBIDUtil.newArray();
        DBIDArrayMIter seed = seeds.iter();
        while (seed.valid()) {
            if (!this.processedIDs.contains((DBIDRef)seed)) {
                currentCluster.add((DBIDRef)seed);
                this.processedIDs.add((DBIDRef)seed);
            } else if (this.noise.contains((DBIDRef)seed)) {
                currentCluster.add((DBIDRef)seed);
                this.noise.remove((DBIDRef)seed);
            }
            seed.advance();
        }
        DBIDVar o = DBIDUtil.newVar();
        while (seeds.size() > 0) {
            seeds.pop(o);
            ArrayModifiableDBIDs neighborhood = this.findSNNNeighbors(snnInstance, (DBIDRef)o);
            if (neighborhood.size() >= this.minpts) {
                DBIDArrayMIter iter = neighborhood.iter();
                while (iter.valid()) {
                    boolean unclassified;
                    boolean inNoise = this.noise.contains((DBIDRef)iter);
                    boolean bl = unclassified = !this.processedIDs.contains((DBIDRef)iter);
                    if (inNoise || unclassified) {
                        if (unclassified) {
                            seeds.add((DBIDRef)iter);
                        }
                        currentCluster.add((DBIDRef)iter);
                        this.processedIDs.add((DBIDRef)iter);
                        if (inNoise) {
                            this.noise.remove((DBIDRef)iter);
                        }
                    }
                    iter.advance();
                }
            }
            if (objprog != null && clusprog != null) {
                objprog.setProcessed(this.processedIDs.size(), LOG);
                int numClusters = currentCluster.size() > this.minpts ? this.resultList.size() + 1 : this.resultList.size();
                clusprog.setProcessed(numClusters, LOG);
            }
            if (this.processedIDs.size() != snnInstance.getRelation().size() || this.noise.size() != 0) continue;
            break;
        }
        if (currentCluster.size() >= this.minpts) {
            this.resultList.add((ModifiableDBIDs)currentCluster);
        } else {
            this.noise.addDBIDs((DBIDs)currentCluster);
            this.noise.add(startObjectID);
            this.processedIDs.add(startObjectID);
        }
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID EPSILON_ID = new OptionID("snn.epsilon", "The minimum SNN density.");
        public static final OptionID MINPTS_ID = new OptionID("snn.minpts", "Threshold for minimum number of points in the epsilon-SNN-neighborhood of a point.");
        protected int epsilon;
        protected int minpts;
        private SharedNearestNeighborSimilarity<O> similarityFunction;

        public void configure(Parameterization config) {
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(SharedNearestNeighborSimilarity.class);
            this.similarityFunction = (SharedNearestNeighborSimilarity)config.tryInstantiate(cls);
            new IntParameter(EPSILON_ID).grab(config, x -> {
                this.epsilon = x;
            });
            ((IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            });
        }

        public SNNClustering<O> make() {
            return new SNNClustering<O>(this.similarityFunction, this.epsilon, this.minpts);
        }
    }
}

