/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.affinitypropagation;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.affinitypropagation.AffinityPropagationInitialization;
import elki.clustering.affinitypropagation.DistanceBasedInitializationWithMedian;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.progress.MutableProgress;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

@Title(value="Affinity Propagation: Clustering by Passing Messages Between Data Points")
@Reference(title="Clustering by Passing Messages Between Data Points", authors="B. J. Frey, D. Dueck", booktitle="Science Vol 315", url="https://doi.org/10.1126/science.1136800", bibkey="doi:10.1126/science.1136800")
public class AffinityPropagation<O>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(AffinityPropagation.class);
    AffinityPropagationInitialization<O> initialization;
    double lambda = 0.5;
    int convergence = 10;
    int maxiter = 1000;

    public AffinityPropagation(AffinityPropagationInitialization<O> initialization, double lambda, int convergence, int maxiter) {
        this.initialization = initialization;
        this.lambda = lambda;
        this.convergence = convergence;
        this.maxiter = maxiter;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.initialization.getInputTypeRestriction()});
    }

    public Clustering<MedoidModel> run(Relation<O> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        int size = ids.size();
        int[] assignment = new int[size];
        double[][] s = this.initialization.getSimilarityMatrix(relation, ids);
        double[][] r = new double[size][size];
        double[][] a = new double[size][size];
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("Affinity Propagation Iteration", LOG) : null;
        MutableProgress aprog = LOG.isVerbose() ? new MutableProgress("Stable assignments", size + 1, LOG) : null;
        int inactive = 0;
        for (int iteration = 0; iteration < this.maxiter && inactive < this.convergence; ++iteration) {
            this.updateResponsibilities(s, a, r);
            this.updateAvailabilities(r, a);
            int changed = this.updateAssignment(r, a, assignment);
            inactive = changed > 0 ? 0 : inactive + 1;
            LOG.incrementProcessed((AbstractProgress)prog);
            if (aprog == null) continue;
            aprog.setProcessed(size - changed, LOG);
        }
        if (aprog != null) {
            aprog.setProcessed(aprog.getTotal(), LOG);
        }
        LOG.setCompleted(prog);
        return this.buildResult(ids, assignment);
    }

    private void updateResponsibilities(double[][] s, double[][] a, double[][] r) {
        int size = r.length;
        for (int i = 0; i < size; ++i) {
            double val;
            int k;
            double[] ai = a[i];
            double[] ri = r[i];
            double[] si = s[i];
            double max1 = Double.NEGATIVE_INFINITY;
            double max2 = Double.NEGATIVE_INFINITY;
            int maxk = -1;
            for (k = 0; k < size; ++k) {
                val = ai[k] + si[k];
                if (val > max1) {
                    max2 = max1;
                    max1 = val;
                    maxk = k;
                    continue;
                }
                if (!(val > max2)) continue;
                max2 = val;
            }
            for (k = 0; k < size; ++k) {
                val = si[k] - (k != maxk ? max1 : max2);
                ri[k] = ri[k] * this.lambda + val * (1.0 - this.lambda);
            }
        }
    }

    private void updateAvailabilities(double[][] r, double[][] a) {
        int size = r.length;
        for (int k = 0; k < size; ++k) {
            int i;
            double colposum = 0.0;
            for (i = 0; i < size; ++i) {
                if (i != k && !(r[i][k] > 0.0)) continue;
                colposum += r[i][k];
            }
            for (i = 0; i < size; ++i) {
                double val = colposum;
                if (i == k || r[i][k] > 0.0) {
                    val -= r[i][k];
                }
                if (i != k && val > 0.0) {
                    val = 0.0;
                }
                a[i][k] = a[i][k] * this.lambda + val * (1.0 - this.lambda);
            }
        }
    }

    private int updateAssignment(double[][] r, double[][] a, int[] assignment) {
        int size = r.length;
        int changed = 0;
        for (int i = 0; i < size; ++i) {
            double[] ai = a[i];
            double[] ri = r[i];
            double max = Double.NEGATIVE_INFINITY;
            int maxj = -1;
            for (int j = 0; j < size; ++j) {
                double v = ai[j] + ri[j];
                if (!(v > max) && (i != j || !(v >= max))) continue;
                max = v;
                maxj = j;
            }
            if (assignment[i] == maxj) continue;
            ++changed;
            assignment[i] = maxj;
        }
        return changed;
    }

    private Int2ObjectOpenHashMap<ModifiableDBIDs> makeClusterMap(ArrayDBIDs ids, int[] assignment) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        DBIDArrayIter i1 = ids.iter();
        int i = 0;
        while (i1.valid()) {
            int c = assignment[i];
            ((ModifiableDBIDs)map.computeIfAbsent(c, x -> DBIDUtil.newArray())).add((DBIDRef)i1);
            i1.advance();
            ++i;
        }
        ObjectIterator iter = map.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            int key;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            int targetkey = key = entry.getIntKey();
            ModifiableDBIDs tids = null;
            while (tids == null && assignment[targetkey] != targetkey) {
                targetkey = assignment[targetkey];
                tids = (ModifiableDBIDs)map.get(targetkey);
            }
            if (tids == null || targetkey == key) continue;
            tids.addDBIDs((DBIDs)entry.getValue());
            iter.remove();
        }
        return map;
    }

    private Clustering<MedoidModel> buildResult(ArrayDBIDs ids, int[] assignment) {
        Int2ObjectOpenHashMap<ModifiableDBIDs> map = this.makeClusterMap(ids, assignment);
        Clustering<MedoidModel> clustering = new Clustering<MedoidModel>();
        DBIDArrayIter i1 = ids.iter();
        Metadata.of(clustering).setLongName("Affinity Propagation Clustering");
        ArrayModifiableDBIDs noise = DBIDUtil.newArray();
        ObjectIterator iter = map.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            i1.seek(entry.getIntKey());
            if (((ModifiableDBIDs)entry.getValue()).size() > 1) {
                MedoidModel mod = new MedoidModel(DBIDUtil.deref((DBIDRef)i1));
                clustering.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)entry.getValue(), mod));
                continue;
            }
            noise.add((DBIDRef)i1);
        }
        if (noise.size() > 0) {
            MedoidModel mod = new MedoidModel(DBIDUtil.deref((DBIDRef)noise.iter()));
            clustering.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)noise, true, mod));
        }
        return clustering;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID INITIALIZATION_ID = new OptionID("ap.initialization", "Similarity matrix initialization..");
        public static final OptionID LAMBDA_ID = new OptionID("ap.lambda", "Dampening factor lambda. Usually 0.5 to 1.");
        public static final OptionID CONVERGENCE_ID = new OptionID("ap.convergence", "Number of stable iterations for convergence.");
        public static final OptionID MAXITER_ID = new OptionID("ap.maxiter", "Maximum number of iterations.");
        AffinityPropagationInitialization<O> initialization;
        double lambda = 0.5;
        int convergence;
        int maxiter;

        public void configure(Parameterization config) {
            new ObjectParameter(INITIALIZATION_ID, AffinityPropagationInitialization.class, DistanceBasedInitializationWithMedian.class).grab(config, x -> {
                this.initialization = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(LAMBDA_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).grab(config, x -> {
                this.lambda = x;
            });
            ((IntParameter)new IntParameter(CONVERGENCE_ID, 15).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.convergence = x;
            });
            new IntParameter(MAXITER_ID, 1000).grab(config, x -> {
                this.maxiter = x;
            });
        }

        public AffinityPropagation<O> make() {
            return new AffinityPropagation<O>(this.initialization, this.lambda, this.convergence, this.maxiter);
        }
    }
}

