/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.affinitypropagation;

import elki.clustering.affinitypropagation.AffinityPropagationInitialization;
import elki.data.type.TypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class DistanceBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    Distance<? super O> distance;
    double quantile;

    public DistanceBasedInitializationWithMedian(Distance<? super O> distance, double quantile) {
        this.distance = distance;
        this.quantile = quantile;
    }

    @Override
    public double[][] getSimilarityMatrix(Relation<O> relation, ArrayDBIDs ids) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        int size = ids.size();
        double[][] mat = new double[size][size];
        double[] flat = new double[size * (size - 1) >> 1];
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            double[] mati = mat[i];
            i2.seek(i + 1);
            for (int k = i + 1; k < size; ++k) {
                mati[k] = -dq.distance((DBIDRef)i1, (DBIDRef)i2);
                mat[k][i] = mati[k];
                flat[j++] = mati[k];
                i2.advance();
            }
            i1.advance();
        }
        assert (j == size * (size - 1) >>> 1);
        double median = QuickSelect.quantile((double[])flat, (double)this.quantile);
        for (int i = 0; i < size; ++i) {
            mat[i][i] = median;
        }
        return mat;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ap.distance", "Distance function to use.");
        Distance<? super O> distance;
        double quantile;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, Distance.class, SquaredEuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5).grab(config, x -> {
                this.quantile = x;
            });
        }

        public DistanceBasedInitializationWithMedian<O> make() {
            return new DistanceBasedInitializationWithMedian<O>(this.distance, this.quantile);
        }
    }
}

