/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.affinitypropagation;

import elki.clustering.affinitypropagation.AffinityPropagationInitialization;
import elki.data.type.TypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.query.QueryBuilder;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.similarity.Similarity;
import elki.similarity.kernel.LinearKernel;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class SimilarityBasedInitializationWithMedian<O>
implements AffinityPropagationInitialization<O> {
    Similarity<? super O> similarity;
    double quantile;

    public SimilarityBasedInitializationWithMedian(Similarity<? super O> similarity, double quantile) {
        this.similarity = similarity;
        this.quantile = quantile;
    }

    @Override
    public double[][] getSimilarityMatrix(Relation<O> relation, ArrayDBIDs ids) {
        int size = ids.size();
        SimilarityQuery sq = new QueryBuilder(relation, this.similarity).similarityQuery();
        double[][] mat = new double[size][size];
        double[] flat = new double[size * (size - 1) >> 1];
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        for (int i = 0; i < size; ++i) {
            mat[i][i] = sq.similarity((DBIDRef)i1, (DBIDRef)i1) * 0.5;
            i1.advance();
        }
        i1.seek(0);
        int j = 0;
        for (int i = 0; i < size; ++i) {
            double[] mati = mat[i];
            i2.seek(i + 1);
            for (int k = i + 1; k < size; ++k) {
                mati[k] = sq.similarity((DBIDRef)i1, (DBIDRef)i2) - mati[i] - mat[k][k];
                mat[k][i] = mati[k];
                flat[j++] = mati[k];
                i2.advance();
            }
            i1.advance();
        }
        assert (j == size * (size - 1) >>> 1);
        double median = QuickSelect.quantile((double[])flat, (double)this.quantile);
        for (int i = 0; i < size; ++i) {
            mat[i][i] = median;
        }
        return mat;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.similarity.getInputTypeRestriction();
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID SIMILARITY_ID = new OptionID("ap.similarity", "Similarity function to use.");
        Similarity<? super O> similarity;
        double quantile;

        public void configure(Parameterization config) {
            new ObjectParameter(SIMILARITY_ID, Similarity.class, LinearKernel.class).grab(config, x -> {
                this.similarity = x;
            });
            new DoubleParameter(AffinityPropagationInitialization.QUANTILE_ID, 0.5).grab(config, x -> {
                this.quantile = x;
            });
        }

        public SimilarityBasedInitializationWithMedian<O> make() {
            return new SimilarityBasedInitializationWithMedian<O>(this.similarity, this.quantile);
        }
    }
}

