/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.biclustering;

import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.BiclusterModel;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.utilities.datastructures.BitsUtil;
import java.util.BitSet;

public abstract class AbstractBiclustering<M extends BiclusterModel>
implements ClusteringAlgorithm<Clustering<M>> {
    protected Relation<? extends NumberVector> relation;
    private DBIDArrayIter iter;
    protected ArrayDBIDs rowIDs;
    private int colDim;

    protected AbstractBiclustering() {
    }

    public final Clustering<M> run(Relation<? extends NumberVector> relation) {
        this.relation = relation;
        this.colDim = RelationUtil.dimensionality(relation);
        this.rowIDs = DBIDUtil.ensureArray((DBIDs)this.relation.getDBIDs());
        this.iter = this.rowIDs.iter();
        return this.biclustering();
    }

    protected abstract Clustering<M> biclustering();

    protected int[] colsBitsetToIDs(BitSet cols) {
        int[] colIDs = new int[cols.cardinality()];
        int colsIndex = 0;
        int i = cols.nextSetBit(0);
        while (i >= 0) {
            colIDs[colsIndex] = i;
            ++colsIndex;
            i = cols.nextSetBit(i + 1);
        }
        return colIDs;
    }

    protected ArrayDBIDs rowsBitsetToIDs(BitSet rows) {
        ArrayModifiableDBIDs rowIDs = DBIDUtil.newArray((int)rows.cardinality());
        DBIDArrayIter iter = this.rowIDs.iter();
        int i = rows.nextSetBit(0);
        while (i >= 0) {
            rowIDs.add((DBIDRef)iter.seek(i));
            i = rows.nextSetBit(i + 1);
        }
        return rowIDs;
    }

    protected Cluster<BiclusterModel> defineBicluster(BitSet rows, BitSet cols) {
        ArrayDBIDs rowIDs = this.rowsBitsetToIDs(rows);
        int[] colIDs = this.colsBitsetToIDs(cols);
        return new Cluster<BiclusterModel>((DBIDs)rowIDs, new BiclusterModel(colIDs));
    }

    protected Cluster<BiclusterModel> defineBicluster(long[] rows, long[] cols) {
        ArrayDBIDs rowIDs = this.rowsBitsetToIDs(rows);
        int[] colIDs = this.colsBitsetToIDs(cols);
        return new Cluster<BiclusterModel>((DBIDs)rowIDs, new BiclusterModel(colIDs));
    }

    protected double valueAt(int row, int col) {
        this.iter.seek(row);
        return ((NumberVector)this.relation.get((DBIDRef)this.iter)).doubleValue(col);
    }

    @Deprecated
    protected DBID getRowDBID(int row) {
        return this.rowIDs.get(row);
    }

    protected int[] colsBitsetToIDs(long[] cols) {
        int[] colIDs = new int[BitsUtil.cardinality((long[])cols)];
        int colsIndex = 0;
        int cpos = 0;
        for (int clpos = 0; clpos < cols.length; ++clpos) {
            long clong = cols[clpos];
            if (clong == 0L) {
                cpos += 64;
                continue;
            }
            int j = 0;
            while (j < 64) {
                if ((clong & 1L) == 1L) {
                    colIDs[colsIndex] = cpos;
                    ++colsIndex;
                }
                ++j;
                ++cpos;
                clong >>>= 1;
            }
        }
        return colIDs;
    }

    protected ArrayDBIDs rowsBitsetToIDs(long[] rows) {
        ArrayModifiableDBIDs rowIDs = DBIDUtil.newArray((int)BitsUtil.cardinality((long[])rows));
        DBIDArrayIter iter = this.rowIDs.iter();
        block0: for (int rlpos = 0; rlpos < rows.length; ++rlpos) {
            long rlong = rows[rlpos];
            if (rlong == 0L) {
                iter.advance(64);
                continue;
            }
            int i = 0;
            while (i < 64) {
                if (!iter.valid()) break block0;
                if ((rlong & 1L) == 1L) {
                    rowIDs.add((DBIDRef)iter);
                }
                ++i;
                rlong >>>= 1;
                iter.advance();
            }
        }
        return rowIDs;
    }

    protected int getRowDim() {
        return this.rowIDs.size();
    }

    protected int getColDim() {
        return this.colDim;
    }
}

