/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.correlation;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.GeneralizedDBSCAN;
import elki.clustering.dbscan.predicates.COPACNeighborPredicate;
import elki.clustering.dbscan.predicates.MinPtsCorePredicate;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.DimensionModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.math.linearalgebra.pca.PCARunner;
import elki.math.linearalgebra.pca.filter.EigenPairFilter;
import elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import elki.result.Metadata;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="COPAC: COrrelation PArtition Clustering")
@Description(value="Partitions a database according to the correlation dimension of its objects and performs a clustering algorithm over the partitions.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM Int. Conf. on Data Mining (SDM'07)", url="https://doi.org/10.1137/1.9781611972771.37", bibkey="DBLP:conf/sdm/AchtertBKKZ07")
public class COPAC
implements ClusteringAlgorithm<Clustering<DimensionModel>> {
    Settings settings;

    public COPAC(Settings settings) {
        this.settings = settings;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public Clustering<DimensionModel> run(Database database, Relation<? extends NumberVector> relation) {
        COPACNeighborPredicate.Instance npred = new COPACNeighborPredicate(this.settings).instantiate(relation);
        MinPtsCorePredicate.Instance cpred = new MinPtsCorePredicate(this.settings.minpts).instantiate(database);
        Clustering<Model> dclusters = new GeneralizedDBSCAN.Instance<DBIDs>(npred, cpred, false).run();
        Clustering<DimensionModel> result = new Clustering<DimensionModel>();
        Metadata.of(result).setLongName("COPAC Clustering");
        It<Cluster<Model>> iter = dclusters.iterToplevelClusters();
        while (iter.valid()) {
            Cluster clus = (Cluster)iter.get();
            if (clus.size() > 0) {
                int dim = npred.dimensionality((DBIDRef)clus.getIDs().iter());
                DimensionModel model = new DimensionModel(dim);
                result.addToplevelCluster(new Cluster<DimensionModel>(clus.getIDs(), model));
            }
            iter.advance();
        }
        return result;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("copac.knn", "Number of neighbors to use for PCA.");
        protected Settings settings;

        public void configure(Parameterization config) {
            this.settings = new Settings();
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.settings.k = x;
            });
            new ObjectParameter(PCARunner.Par.PCARUNNER_ID, PCARunner.class, PCARunner.class).grab(config, x -> {
                this.settings.pca = x;
            });
            new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, EigenPairFilter.class, PercentageEigenPairFilter.class).grab(config, x -> {
                this.settings.filter = x;
            });
            ((DoubleParameter)new DoubleParameter(DBSCAN.Par.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.settings.epsilon = x;
            });
            ((IntParameter)new IntParameter(DBSCAN.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.settings.minpts = x;
            });
        }

        public COPAC make() {
            return new COPAC(this.settings);
        }
    }

    public static class Settings {
        public int k;
        public PCARunner pca;
        public EigenPairFilter filter;
        public double epsilon;
        public int minpts;
    }
}

