/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.correlation;

import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.GeneralizedDBSCAN;
import elki.clustering.dbscan.predicates.FourCCorePredicate;
import elki.clustering.dbscan.predicates.FourCNeighborPredicate;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.math.linearalgebra.pca.filter.LimitEigenPairFilter;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="4C: Computing Correlation Connected Clusters")
@Description(value="4C identifies local subgroups of data objects sharing a uniform correlation. The algorithm is based on a combination of PCA and density-based clustering (DBSCAN).")
@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourC
extends GeneralizedDBSCAN {
    public FourC(Settings settings) {
        super(new FourCNeighborPredicate(settings), new FourCCorePredicate(settings), false);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par
    implements Parameterizer {
        Settings settings;

        public void configure(Parameterization config) {
            this.settings = (Settings)config.tryInstantiate(Settings.class);
        }

        public FourC make() {
            return new FourC(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public boolean absolute = false;
        public double delta = 0.0;
        public double kappa = 50.0;
        public int lambda = Integer.MAX_VALUE;
        public int minpts;

        public static class Par
        implements Parameterizer {
            public static final double DEFAULT_DELTA = 0.1;
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            public void configure(Parameterization config) {
                this.settings = new Settings();
                ((DoubleParameter)new DoubleParameter(DBSCAN.Par.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                    this.settings.epsilon = x;
                });
                ((IntParameter)new IntParameter(DBSCAN.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.settings.minpts = x;
                });
                new Flag(LimitEigenPairFilter.Par.EIGENPAIR_FILTER_ABSOLUTE).grab(config, x -> {
                    this.settings.absolute = x;
                });
                DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(LimitEigenPairFilter.Par.EIGENPAIR_FILTER_DELTA).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (!this.settings.absolute) {
                    deltaP.setDefaultValue((Object)0.1);
                } else {
                    deltaP.addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
                }
                deltaP.grab(config, x -> {
                    this.settings.delta = x;
                });
                ((DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0)).grab(config, x1 -> {
                    this.settings.kappa = x1;
                });
                ((IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)).grab(config, x -> {
                    this.settings.lambda = x;
                });
            }

            public Object make() {
                return this.settings;
            }
        }
    }
}

