/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.correlation;

import elki.clustering.AbstractProjectedClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.IndefiniteProgress;
import elki.math.linearalgebra.Centroid;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.PCARunner;
import elki.result.Metadata;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jafama.FastMath;

@Title(value="ORCLUS: Arbitrarily ORiented projected CLUSter generation")
@Description(value="Algorithm to find correlation clusters in high dimensional spaces.")
@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Finding Generalized Projected Clusters in High Dimensional Spaces", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '00)", url="https://doi.org/10.1145/342009.335383", bibkey="DBLP:conf/sigmod/AggarwalY00")
public class ORCLUS
extends AbstractProjectedClustering<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ORCLUS.class);
    private double alpha;
    private RandomFactory rnd;
    private PCARunner pca;

    public ORCLUS(int k, int k_i, int l, double alpha, RandomFactory rnd, PCARunner pca) {
        super(k, k_i, l);
        this.alpha = alpha;
        this.rnd = rnd;
        this.pca = pca;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public Clustering<Model> run(Relation<? extends NumberVector> relation) {
        IndefiniteProgress cprogress;
        int dim_c = RelationUtil.dimensionality(relation);
        if (dim_c < this.l) {
            throw new IllegalStateException("Dimensionality of data < parameter l! (" + dim_c + " < " + this.l + ")");
        }
        int k_c = Math.min(relation.size(), this.k_i * this.k);
        List<ORCLUSCluster> clusters = this.initialSeeds(relation, k_c);
        double beta = FastMath.exp((double)(-FastMath.log((double)((double)dim_c / (double)this.l)) * FastMath.log((double)(1.0 / this.alpha)) / FastMath.log((double)((double)k_c / (double)this.k))));
        IndefiniteProgress indefiniteProgress = cprogress = LOG.isVerbose() ? new IndefiniteProgress("Current number of clusters:", LOG) : null;
        while (k_c > this.k) {
            this.assign(relation, clusters);
            for (ORCLUSCluster cluster : clusters) {
                if (cluster.objectIDs.size() <= 0) continue;
                cluster.basis = this.findBasis(relation, cluster, dim_c);
            }
            k_c = (int)Math.max((double)this.k, (double)k_c * this.alpha);
            dim_c = (int)Math.max((double)this.l, (double)dim_c * beta);
            this.merge(relation, clusters, k_c, dim_c, cprogress);
            if (cprogress == null) continue;
            cprogress.setProcessed(clusters.size(), LOG);
        }
        this.assign(relation, clusters);
        LOG.setCompleted(cprogress);
        Clustering<Model> result = new Clustering<Model>();
        Metadata.of(result).setLongName("ORCLUS Clustering");
        for (ORCLUSCluster c : clusters) {
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)c.objectIDs, ClusterModel.CLUSTER));
        }
        return result;
    }

    private List<ORCLUSCluster> initialSeeds(Relation<? extends NumberVector> database, int k) {
        ModifiableDBIDs randomSample = DBIDUtil.randomSample((DBIDs)database.getDBIDs(), (int)k, (RandomFactory)this.rnd);
        ArrayList<ORCLUSCluster> seeds = new ArrayList<ORCLUSCluster>(k);
        DBIDIter iter = randomSample.iter();
        while (iter.valid()) {
            seeds.add(new ORCLUSCluster(((NumberVector)database.get((DBIDRef)iter)).toArray(), (DBIDRef)iter));
            iter.advance();
        }
        return seeds;
    }

    private void assign(Relation<? extends NumberVector> database, List<ORCLUSCluster> clusters) {
        SquaredEuclideanDistance distFunc = SquaredEuclideanDistance.STATIC;
        for (ORCLUSCluster oRCLUSCluster : clusters) {
            oRCLUSCluster.objectIDs.clear();
        }
        ArrayList<double[]> projectedCentroids = new ArrayList<double[]>(clusters.size());
        for (ORCLUSCluster c : clusters) {
            projectedCentroids.add(VMath.times((double[][])c.basis, (double[])c.centroid));
        }
        DBIDIter dBIDIter = database.iterDBIDs();
        while (dBIDIter.valid()) {
            double[] o = ((NumberVector)database.get((DBIDRef)dBIDIter)).toArray();
            ORCLUSCluster minCluster = clusters.get(0);
            double minDist = distFunc.distance(VMath.times((double[][])minCluster.basis, (double[])o), (double[])projectedCentroids.get(0));
            for (int i = 1; i < clusters.size(); ++i) {
                ORCLUSCluster c = clusters.get(i);
                double dist = distFunc.distance(VMath.times((double[][])c.basis, (double[])o), (double[])projectedCentroids.get(i));
                if (!(dist < minDist)) continue;
                minDist = dist;
                minCluster = c;
            }
            minCluster.objectIDs.add((DBIDRef)dBIDIter);
            dBIDIter.advance();
        }
        for (ORCLUSCluster cluster : clusters) {
            if (cluster.objectIDs.size() <= 0) continue;
            cluster.centroid = Centroid.make(database, (DBIDs)cluster.objectIDs).toArray();
        }
    }

    private double[][] findBasis(Relation<? extends NumberVector> database, ORCLUSCluster cluster, int dim) {
        double[][] evs = this.pca.processIds((DBIDs)cluster.objectIDs, database).getEigenvectors();
        return (double[][])Arrays.copyOfRange(evs, evs.length - dim, evs.length);
    }

    private void merge(Relation<? extends NumberVector> relation, List<ORCLUSCluster> clusters, int k_new, int d_new, IndefiniteProgress cprogress) {
        ArrayList<ProjectedEnergy> projectedEnergies = new ArrayList<ProjectedEnergy>(clusters.size() * (clusters.size() - 1) >>> 1);
        for (int i = 0; i < clusters.size(); ++i) {
            ORCLUSCluster c_i = clusters.get(i);
            for (int j = i + 1; j < clusters.size(); ++j) {
                projectedEnergies.add(this.projectedEnergy(relation, c_i, clusters.get(j), i, j, d_new));
            }
        }
        while (clusters.size() > k_new) {
            if (cprogress != null) {
                cprogress.setProcessed(clusters.size(), LOG);
            }
            ProjectedEnergy minPE = (ProjectedEnergy)Collections.min(projectedEnergies);
            ORCLUSCluster c_ij = minPE.cluster;
            int i = minPE.i;
            int j = minPE.j;
            clusters.set(i, c_ij);
            clusters.remove(j);
            projectedEnergies.removeIf(pe -> pe.i == i || pe.i == j || pe.j == i || pe.j == j);
            for (ProjectedEnergy pe2 : projectedEnergies) {
                if (pe2.i > j) {
                    --pe2.i;
                }
                if (pe2.j <= j) continue;
                --pe2.j;
            }
            for (int c = 0; c < clusters.size(); ++c) {
                if (c < i) {
                    projectedEnergies.add(this.projectedEnergy(relation, clusters.get(c), c_ij, c, i, d_new));
                    continue;
                }
                if (c <= i) continue;
                projectedEnergies.add(this.projectedEnergy(relation, clusters.get(c), c_ij, i, c, d_new));
            }
        }
    }

    private ProjectedEnergy projectedEnergy(Relation<? extends NumberVector> relation, ORCLUSCluster c_i, ORCLUSCluster c_j, int i, int j, int dim) {
        SquaredEuclideanDistance distFunc = SquaredEuclideanDistance.STATIC;
        ORCLUSCluster c_ij = this.union(relation, c_i, c_j, dim);
        double sum = 0.0;
        double[] c_proj = VMath.times((double[][])c_ij.basis, (double[])c_ij.centroid);
        DBIDMIter iter = c_ij.objectIDs.iter();
        while (iter.valid()) {
            sum += distFunc.distance(c_proj, VMath.times((double[][])c_ij.basis, (double[])((NumberVector)relation.get((DBIDRef)iter)).toArray()));
            iter.advance();
        }
        return new ProjectedEnergy(i, j, c_ij, sum /= (double)c_ij.objectIDs.size());
    }

    private ORCLUSCluster union(Relation<? extends NumberVector> relation, ORCLUSCluster c1, ORCLUSCluster c2, int dim) {
        ORCLUSCluster c = new ORCLUSCluster();
        c.objectIDs = DBIDUtil.union((DBIDs)c1.objectIDs, (DBIDs)c2.objectIDs);
        if (!c.objectIDs.isEmpty()) {
            c.centroid = Centroid.make(relation, (DBIDs)c.objectIDs).getArrayRef();
            c.basis = this.findBasis(relation, c, dim);
        } else {
            c.centroid = VMath.timesEquals((double[])VMath.plus((double[])c1.centroid, (double[])c2.centroid), (double)0.5);
            c.basis = VMath.identity((int)dim, (int)c.centroid.length);
        }
        return c;
    }

    public static class Par
    extends AbstractProjectedClustering.Par {
        public static final OptionID ALPHA_ID = new OptionID("orclus.alpha", "The factor for reducing the number of current clusters in each iteration.");
        public static final OptionID SEED_ID = new OptionID("orclus.seed", "The random number generator seed.");
        protected double alpha;
        protected RandomFactory rnd;
        protected PCARunner pca;

        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(K_I_ID, 30).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k_i = x;
            });
            ((IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.l = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                this.alpha = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
            new ObjectParameter(PCARunner.Par.PCARUNNER_ID, PCARunner.class, PCARunner.class).grab(config, x -> {
                this.pca = x;
            });
        }

        public ORCLUS make() {
            return new ORCLUS(this.k, this.k_i, this.l, this.alpha, this.rnd, this.pca);
        }
    }

    private static final class ProjectedEnergy
    implements Comparable<ProjectedEnergy> {
        int i;
        int j;
        ORCLUSCluster cluster;
        double projectedEnergy;

        ProjectedEnergy(int i, int j, ORCLUSCluster cluster, double projectedEnergy) {
            this.i = i;
            this.j = j;
            this.cluster = cluster;
            this.projectedEnergy = projectedEnergy;
        }

        @Override
        public int compareTo(ProjectedEnergy o) {
            return Double.compare(this.projectedEnergy, o.projectedEnergy);
        }
    }

    private static final class ORCLUSCluster {
        ModifiableDBIDs objectIDs = DBIDUtil.newArray();
        double[][] basis;
        double[] centroid;

        ORCLUSCluster() {
        }

        ORCLUSCluster(double[] o, DBIDRef id) {
            this.centroid = o;
            this.basis = VMath.unitMatrix((int)o.length);
            this.objectIDs.add(id);
        }
    }
}

