/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.dbscan.predicates.CorePredicate;
import elki.clustering.dbscan.predicates.EpsilonNeighborPredicate;
import elki.clustering.dbscan.predicates.MinPtsCorePredicate;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.CoreObjectsModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;

@Reference(authors="J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="Density-Based Clustering in Spatial Databases: The Algorithm GDBSCAN and Its Applications", booktitle="Data Mining and Knowledge Discovery", url="https://doi.org/10.1023/A:1009745219419", bibkey="DBLP:journals/datamine/SanderEKX98")
public class GeneralizedDBSCAN
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(GeneralizedDBSCAN.class);
    protected NeighborPredicate<?> npred;
    protected CorePredicate<?> corepred;
    protected boolean coremodel = false;

    public GeneralizedDBSCAN(NeighborPredicate<?> npred, CorePredicate<?> corepred, boolean coremodel) {
        this.npred = npred;
        this.corepred = corepred;
        this.coremodel = coremodel;
        CorePredicate<?> cp = corepred;
        if (!cp.acceptsType(npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
    }

    @Override
    public Clustering<Model> autorun(Database database) {
        CorePredicate<?> cp = this.corepred;
        if (!cp.acceptsType(this.npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
        return new Instance(this.npred.instantiate(database), cp.instantiate(database), this.coremodel).run();
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.npred.getInputTypeRestriction()});
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NEIGHBORHOODPRED_ID = new OptionID("gdbscan.neighborhood", "Neighborhood predicate for Generalized DBSCAN");
        public static final OptionID COREPRED_ID = new OptionID("gdbscan.core", "Core point predicate for Generalized DBSCAN");
        public static final OptionID COREMODEL_ID = new OptionID("gdbscan.core-model", "Use a model that keeps track of core points. Needs more memory.");
        protected NeighborPredicate<?> npred = null;
        protected CorePredicate<?> corepred = null;
        protected boolean coremodel = false;

        public void configure(Parameterization config) {
            CorePredicate<?> cp;
            new ObjectParameter(NEIGHBORHOODPRED_ID, NeighborPredicate.class, EpsilonNeighborPredicate.class).grab(config, x -> {
                this.npred = x;
            });
            ObjectParameter corepredP = new ObjectParameter(COREPRED_ID, CorePredicate.class, MinPtsCorePredicate.class);
            corepredP.grab(config, x -> {
                this.corepred = x;
            });
            if (this.npred != null && this.corepred != null && !(cp = this.corepred).acceptsType(this.npred.getOutputType())) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)corepredP, corepredP.getValueAsString(), "Neighbor predicate and core predicate are not compatible."));
            }
            new Flag(COREMODEL_ID).grab(config, x -> {
                this.coremodel = x;
            });
        }

        public GeneralizedDBSCAN make() {
            return new GeneralizedDBSCAN(this.npred, this.corepred, this.coremodel);
        }
    }

    public static class Instance<T> {
        protected static final int UNPROCESSED = 0;
        protected static final int NOISE = 1;
        protected final NeighborPredicate.Instance<T> npred;
        protected final CorePredicate.Instance<? super T> corepred;
        protected boolean coremodel = false;

        public Instance(NeighborPredicate.Instance<T> npred, CorePredicate.Instance<? super T> corepred, boolean coremodel) {
            this.npred = npred;
            this.corepred = corepred;
            this.coremodel = coremodel;
        }

        public Clustering<Model> run() {
            int cid;
            DBIDs ids = this.npred.getIDs();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Generalized DBSCAN Clustering", ids.size(), LOG) : null;
            IndefiniteProgress clusprogress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
            WritableIntegerDataStore clusterids = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)1, (int)0);
            IntArrayList clustersizes = new IntArrayList();
            clustersizes.add(0);
            clustersizes.add(0);
            ArrayModifiableDBIDs activeSet = DBIDUtil.newArray();
            int clusterid = 2;
            DBIDIter id = ids.iter();
            while (id.valid()) {
                if (clusterids.intValue((DBIDRef)id) == 0) {
                    T neighbors = this.npred.getNeighbors((DBIDRef)id);
                    if (this.corepred.isCorePoint((DBIDRef)id, neighbors)) {
                        LOG.incrementProcessed((AbstractProgress)clusprogress);
                        clustersizes.add(this.expandCluster((DBIDRef)id, clusterid, clusterids, neighbors, activeSet, progress));
                        ++clusterid;
                    } else {
                        clusterids.putInt((DBIDRef)id, 1);
                        clustersizes.set(1, clustersizes.getInt(1) + 1);
                    }
                    LOG.incrementProcessed((AbstractProgress)progress);
                }
                id.advance();
            }
            LOG.ensureCompleted(progress);
            LOG.setCompleted(clusprogress);
            ArrayModifiableDBIDs[] clusterlists = new ArrayModifiableDBIDs[clusterid];
            ArrayModifiableDBIDs[] corelists = this.coremodel ? new ArrayModifiableDBIDs[clusterid] : null;
            for (int i = 0; i < clustersizes.size(); ++i) {
                clusterlists[i] = DBIDUtil.newArray((int)clustersizes.getInt(i));
                if (corelists == null) continue;
                corelists[i] = DBIDUtil.newArray((int)clustersizes.getInt(i));
            }
            DBIDIter id2 = ids.iter();
            while (id2.valid()) {
                cid = clusterids.intValue((DBIDRef)id2);
                int cluster = cid < 0 ? -cid : cid;
                clusterlists[cluster].add((DBIDRef)id2);
                if (corelists != null && cid > 1) {
                    corelists[cluster].add((DBIDRef)id2);
                }
                id2.advance();
            }
            clusterids.destroy();
            Clustering<Model> result = new Clustering<Model>();
            Metadata.of(result).setLongName("Generalized DBSCAN Clustering");
            for (cid = 1; cid < clusterlists.length; ++cid) {
                boolean isNoise = cid == 1;
                Model m = this.coremodel ? new CoreObjectsModel((DBIDs)corelists[cid]) : ClusterModel.CLUSTER;
                result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)clusterlists[cid], isNoise, (ClusterModel)m));
            }
            return result;
        }

        protected int expandCluster(DBIDRef seed, int clusterid, WritableIntegerDataStore clusterids, T neighbors, ArrayModifiableDBIDs activeSet, FiniteProgress progress) {
            assert (activeSet.size() == 0);
            int clustersize = 1 + this.processCorePoint(seed, neighbors, clusterid, clusterids, activeSet);
            DBIDVar id = DBIDUtil.newVar();
            while (!activeSet.isEmpty()) {
                activeSet.pop(id);
                T newneighbors = this.npred.getNeighbors((DBIDRef)id);
                if (this.corepred.isCorePoint((DBIDRef)id, newneighbors)) {
                    clustersize += this.processCorePoint((DBIDRef)id, newneighbors, clusterid, clusterids, activeSet);
                }
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            return clustersize;
        }

        protected int processCorePoint(DBIDRef seed, T newneighbors, int clusterid, WritableIntegerDataStore clusterids, ArrayModifiableDBIDs activeSet) {
            clusterids.putInt(seed, clusterid);
            int clustersize = 0;
            DBIDIter it = this.npred.iterDBIDs(newneighbors);
            while (it.valid()) {
                block5: {
                    block4: {
                        int oldassign;
                        block3: {
                            oldassign = clusterids.intValue((DBIDRef)it);
                            if (oldassign != 0) break block3;
                            activeSet.add((DBIDRef)it);
                            break block4;
                        }
                        if (oldassign != 1) break block5;
                    }
                    ++clustersize;
                    clusterids.putInt((DBIDRef)it, -clusterid);
                }
                it.advance();
            }
            return clustersize;
        }
    }
}

