/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.progress.StepProgress;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import net.jafama.FastMath;

@Title(value="LSDBC: Locally Scaled Density Based Clustering")
@Reference(authors="E. Bi\u00e7ici, D. Yuret", title="Locally Scaled Density Based Clustering", booktitle="Adaptive and Natural Computing Algorithms", url="https://doi.org/10.1007/978-3-540-71618-1_82", bibkey="DBLP:conf/icannga/BiciciY07")
@Priority(value=100)
public class LSDBC<O extends NumberVector>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(LSDBC.class);
    protected int kplus;
    protected double alpha;
    protected Distance<? super O> distance;
    protected static int UNPROCESSED = 0;
    protected static int NOISE = 1;

    public LSDBC(Distance<? super O> distance, int k, double alpha) {
        this.distance = distance;
        this.kplus = k + 1;
        this.alpha = alpha;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public Clustering<Model> run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LSDBC", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        double factor = FastMath.pow((double)2.0, (double)(this.alpha / (double)dim));
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing kNN neighborhoods");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Sorting by density");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        this.fillDensities((KNNSearcher<DBIDRef>)knnq, ids, dens);
        ArrayModifiableDBIDs sids = DBIDUtil.newArray((DBIDs)ids);
        sids.sort((Comparator)new DataStoreUtil.AscendingByDoubleDataStore((DoubleDataStore)dens));
        LOG.beginStep(stepprog, 3, "Computing clusters");
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("LSDBC Clustering", ids.size(), LOG) : null;
        IndefiniteProgress clusprogress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
        WritableIntegerDataStore clusterids = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)1, (int)UNPROCESSED);
        IntArrayList clustersizes = new IntArrayList();
        clustersizes.add(0);
        clustersizes.add(0);
        int clusterid = NOISE + 1;
        DBIDArrayMIter id = sids.iter();
        while (id.valid()) {
            if (clusterids.intValue((DBIDRef)id) == UNPROCESSED) {
                KNNList neighbors = knnq.getKNN((Object)id, this.kplus);
                if (this.isLocalMaximum(neighbors.getKNNDistance(), (DBIDs)neighbors, dens)) {
                    double mindens = factor * neighbors.getKNNDistance();
                    clusterids.putInt((DBIDRef)id, clusterid);
                    clustersizes.add(this.expandCluster(clusterid, clusterids, (KNNSearcher<DBIDRef>)knnq, (DBIDs)neighbors, mindens, progress));
                    ++clusterid;
                    if (clusprogress != null) {
                        clusprogress.setProcessed(clusterid, LOG);
                    }
                } else {
                    clusterids.putInt((DBIDRef)id, NOISE);
                    clustersizes.set(NOISE, clustersizes.getInt(NOISE) + 1);
                }
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            id.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.setCompleted(clusprogress);
        LOG.setCompleted(stepprog);
        ArrayList<ArrayModifiableDBIDs> clusterlists = new ArrayList<ArrayModifiableDBIDs>(clusterid);
        for (int i = 0; i < clustersizes.size(); ++i) {
            clusterlists.add(DBIDUtil.newArray((int)clustersizes.getInt(i)));
        }
        DBIDIter id2 = ids.iter();
        while (id2.valid()) {
            ((ArrayModifiableDBIDs)clusterlists.get(Math.abs(clusterids.intValue((DBIDRef)id2)))).add((DBIDRef)id2);
            id2.advance();
        }
        clusterids.destroy();
        Clustering<Model> result = new Clustering<Model>();
        Metadata.of(result).setLongName("LSDBC Clustering");
        for (int cid = NOISE; cid < clusterlists.size(); ++cid) {
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)clusterlists.get(cid), cid == NOISE, ClusterModel.CLUSTER));
        }
        return result;
    }

    private boolean isLocalMaximum(double kdist, DBIDs neighbors, WritableDoubleDataStore kdists) {
        DBIDIter it = neighbors.iter();
        while (it.valid()) {
            if (kdists.doubleValue((DBIDRef)it) < kdist) {
                return false;
            }
            it.advance();
        }
        return true;
    }

    protected int expandCluster(int clusterid, WritableIntegerDataStore clusterids, KNNSearcher<DBIDRef> knnq, DBIDs neighbors, double maxkdist, FiniteProgress progress) {
        int clustersize = 1;
        ArrayModifiableDBIDs activeSet = DBIDUtil.newArray();
        activeSet.addDBIDs(neighbors);
        DBIDVar id = DBIDUtil.newVar();
        while (!activeSet.isEmpty()) {
            activeSet.pop(id);
            int oldclus = clusterids.intValue((DBIDRef)id);
            if (oldclus == NOISE) {
                ++clustersize;
                clusterids.putInt((DBIDRef)id, -clusterid);
                continue;
            }
            if (oldclus != UNPROCESSED) continue;
            ++clustersize;
            KNNList newneighbors = knnq.getKNN((Object)id, this.kplus);
            if (newneighbors.getKNNDistance() <= maxkdist) {
                activeSet.addDBIDs((DBIDs)newneighbors);
            }
            clusterids.putInt((DBIDRef)id, clusterid);
            LOG.incrementProcessed((AbstractProgress)progress);
        }
        return clustersize;
    }

    private void fillDensities(KNNSearcher<DBIDRef> knnq, DBIDs ids, WritableDoubleDataStore dens) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            dens.putDouble((DBIDRef)iter, knnq.getKNN((Object)iter, this.kplus).getKNNDistance());
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("lsdbc.k", "Neighborhood size (k)");
        public static final OptionID ALPHA_ID = new OptionID("lsdbc.alpha", "Density difference factor");
        protected int k;
        protected double alpha;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((DoubleParameter)new DoubleParameter(ALPHA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.alpha = x;
            });
        }

        public LSDBC<O> make() {
            return new LSDBC<O>(this.distance, this.k, this.alpha);
        }
    }
}

