/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.parallel;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.dbscan.predicates.CorePredicate;
import elki.clustering.dbscan.predicates.EpsilonNeighborPredicate;
import elki.clustering.dbscan.predicates.MinPtsCorePredicate;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.clustering.dbscan.util.Assignment;
import elki.clustering.dbscan.util.Border;
import elki.clustering.dbscan.util.Core;
import elki.clustering.dbscan.util.MultiBorder;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.parallel.Executor;
import elki.parallel.ParallelExecutor;
import elki.parallel.processor.Processor;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.Arrays;

@Reference(prefix="closely related", authors="M. Patwary, D. Palsetia, A. Agrawal, W. K. Liao, F. Manne, A. Choudhary", title="A new scalable parallel DBSCAN algorithm using the disjoint-set data structure", booktitle="IEEE Int. Conf. for High Performance Computing, Networking, Storage and Analysis (SC)", url="https://doi.org/10.1109/SC.2012.9", bibkey="DBLP:conf/sc/PatwaryPALMC12")
public class ParallelGeneralizedDBSCAN
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ParallelGeneralizedDBSCAN.class);
    protected NeighborPredicate<?> npred;
    protected CorePredicate<?> corepred;
    protected boolean coremodel = false;

    public ParallelGeneralizedDBSCAN(NeighborPredicate<?> npred, CorePredicate<?> corepred, boolean coremodel) {
        this.npred = npred;
        this.corepred = corepred;
        this.coremodel = coremodel;
        CorePredicate<?> cp = corepred;
        if (!cp.acceptsType(npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.npred.getInputTypeRestriction()});
    }

    @Override
    public Clustering<Model> autorun(Database database) {
        CorePredicate<?> cp = this.corepred;
        if (!cp.acceptsType(this.npred.getOutputType())) {
            throw new AbortException("Predicates are not compatible.");
        }
        return new Instance(database, this.npred, cp, this.coremodel).run();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NEIGHBORHOODPRED_ID = new OptionID("gdbscan.neighborhood", "Neighborhood predicate for Generalized DBSCAN");
        public static final OptionID COREPRED_ID = new OptionID("gdbscan.core", "Core point predicate for Generalized DBSCAN");
        public static final OptionID COREMODEL_ID = new OptionID("gdbscan.core-model", "Use a model that keeps track of core points. Needs more memory.");
        protected NeighborPredicate<?> npred = null;
        protected CorePredicate<?> corepred = null;
        protected boolean coremodel = false;

        public void configure(Parameterization config) {
            CorePredicate<?> cp;
            new ObjectParameter(NEIGHBORHOODPRED_ID, NeighborPredicate.class, EpsilonNeighborPredicate.class).grab(config, x -> {
                this.npred = x;
            });
            ObjectParameter corepredP = new ObjectParameter(COREPRED_ID, CorePredicate.class, MinPtsCorePredicate.class);
            corepredP.grab(config, x -> {
                this.corepred = x;
            });
            if (this.npred != null && this.corepred != null && !(cp = this.corepred).acceptsType(this.npred.getOutputType())) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)corepredP, corepredP.getValueAsString(), "Neighbor predicate and core predicate are not compatible."));
            }
            new Flag(COREMODEL_ID).grab(config, x -> {
                this.coremodel = x;
            });
        }

        public ParallelGeneralizedDBSCAN make() {
            return new ParallelGeneralizedDBSCAN(this.npred, this.corepred, this.coremodel);
        }
    }

    public static class Instance<T>
    implements Processor {
        protected final NeighborPredicate.Instance<T> npred;
        protected final CorePredicate.Instance<? super T> corepred;
        protected boolean coremodel = false;
        private WritableDataStore<Assignment> clusterids;
        private Core[] cores;
        private Border[] borders;
        private int nextclus = 0;
        private Database database;
        private NeighborPredicate<? extends T> npreds;
        private FiniteProgress progress;

        public Instance(Database database, NeighborPredicate<T> npreds, CorePredicate<? super T> corepred, boolean coremodel) {
            this.npred = npreds.instantiate(database);
            this.database = database;
            this.npreds = npreds;
            this.corepred = corepred.instantiate(database);
            this.coremodel = coremodel;
            this.clusterids = DataStoreUtil.makeStorage((DBIDs)this.npred.getIDs(), (int)1, Assignment.class);
            this.cores = new Core[100];
            this.borders = new Border[100];
        }

        public Clustering<Model> run() {
            DBIDs ids = this.npred.getIDs();
            this.progress = LOG.isVerbose() ? new FiniteProgress("DBSCAN clustering", ids.size(), LOG) : null;
            ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{this});
            LOG.ensureCompleted(this.progress);
            FiniteProgress pprog = LOG.isVerbose() ? new FiniteProgress("Building final result", ids.size(), LOG) : null;
            ModifiableDBIDs[] clusters = new ModifiableDBIDs[this.nextclus];
            ArrayModifiableDBIDs noise = DBIDUtil.newArray();
            DBIDIter it = ids.iter();
            while (it.valid()) {
                Assignment cids = (Assignment)this.clusterids.get((DBIDRef)it);
                if (cids == null) {
                    noise.add((DBIDRef)it);
                    LOG.incrementProcessed((AbstractProgress)pprog);
                } else {
                    if (cids instanceof MultiBorder) {
                        cids = ((MultiBorder)cids).getCore();
                    } else if (cids instanceof Border) {
                        cids = ((Border)cids).core;
                    }
                    assert (cids instanceof Core);
                    Core co = (Core)cids;
                    while (this.cores[co.num].num != co.num) {
                        co.num = this.cores[co.num].num;
                        co = this.cores[co.num];
                    }
                    ModifiableDBIDs clu = clusters[co.num];
                    if (clu == null) {
                        clu = clusters[co.num] = DBIDUtil.newArray();
                    }
                    clu.add((DBIDRef)it);
                    LOG.incrementProcessed((AbstractProgress)pprog);
                }
                it.advance();
            }
            LOG.ensureCompleted(pprog);
            this.clusterids.destroy();
            Clustering<Model> result = new Clustering<Model>();
            Metadata.of(result).setLongName("Generalized DBSCAN Clustering");
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null) continue;
                result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)clusters[i], ClusterModel.CLUSTER));
            }
            if (noise.size() > 0) {
                result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)noise, true, ClusterModel.CLUSTER));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processNeighbors(DBIDRef id, T neighbors) {
            if (!this.corepred.isCorePoint(id, neighbors)) {
                LOG.incrementProcessed((AbstractProgress)this.progress);
                return;
            }
            Core core = null;
            DBIDIter it = this.npred.iterDBIDs(neighbors);
            while (it.valid()) {
                Assignment cand = (Assignment)this.clusterids.get((DBIDRef)it);
                if (cand instanceof Core) {
                    core = (Core)cand;
                    break;
                }
                it.advance();
            }
            Instance instance = this;
            synchronized (instance) {
                if (core == null) {
                    if (this.nextclus == this.cores.length) {
                        this.cores = Arrays.copyOf(this.cores, this.cores.length + (this.cores.length >> 1));
                        this.borders = Arrays.copyOf(this.borders, this.cores.length);
                    }
                    core = this.cores[this.nextclus] = new Core(this.nextclus);
                    this.borders[this.nextclus] = new Border(core);
                    ++this.nextclus;
                }
                Border border = this.borders[core.num];
                this.clusterids.put(id, (Object)core);
                DBIDIter it2 = this.npred.iterDBIDs(neighbors);
                while (it2.valid()) {
                    Assignment oclus = (Assignment)this.clusterids.get((DBIDRef)it2);
                    if (oclus != core) {
                        if (oclus == null) {
                            this.clusterids.put((DBIDRef)it2, (Object)border);
                        } else if (oclus instanceof Core) {
                            core.mergeWith((Core)oclus);
                        } else if (oclus instanceof Border) {
                            Border oborder = (Border)oclus;
                            if (border.core.num != oborder.core.num) {
                                this.clusterids.put((DBIDRef)it2, (Object)new MultiBorder(border, oborder));
                            }
                        } else {
                            assert (oclus instanceof MultiBorder);
                            this.clusterids.put((DBIDRef)it2, (Object)((MultiBorder)oclus).update(border));
                        }
                    }
                    it2.advance();
                }
            }
            LOG.incrementProcessed((AbstractProgress)this.progress);
        }

        public Mapper instantiate(Executor executor) {
            NeighborPredicate.Instance<? extends T> inst = this.npreds.instantiate(this.database);
            return new Mapper(inst);
        }

        public void cleanup(Processor.Instance inst) {
        }

        private class Mapper
        implements Processor.Instance {
            NeighborPredicate.Instance<? extends T> predicate;

            public Mapper(NeighborPredicate.Instance<? extends T> predicate) {
                this.predicate = predicate;
            }

            public void map(DBIDRef id) {
                Instance.this.processNeighbors(id, this.predicate.getNeighbors(id));
            }
        }
    }
}

