/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.Algorithm;
import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.data.type.TypeInformation;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRangeQueryNeighborPredicate<O, M, N>
implements NeighborPredicate<N> {
    protected double epsilon;
    protected Distance<? super O> distance;

    public AbstractRangeQueryNeighborPredicate(double epsilon, Distance<? super O> distance) {
        this.epsilon = epsilon;
        this.distance = distance;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public DataStore<M> preprocess(Class<? super M> modelcls, Relation<? extends O> relation, RangeSearcher<DBIDRef> query) {
        WritableDataStore storage = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, modelcls);
        Duration time = this.getLogger().newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), this.getLogger()) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            DoubleDBIDList neighbors = query.getRange((Object)iditer, this.epsilon);
            storage.put((DBIDRef)iditer, this.computeLocalModel((DBIDRef)iditer, neighbors, relation));
            this.getLogger().incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        this.getLogger().ensureCompleted(progress);
        this.getLogger().statistics((Statistic)time.end());
        return storage;
    }

    protected abstract M computeLocalModel(DBIDRef var1, DoubleDBIDList var2, Relation<? extends O> var3);

    abstract Logging getLogger();

    public static abstract class Par<O>
    implements Parameterizer {
        double epsilon;
        Distance<O> distfun = null;

        public void configure(Parameterization config) {
            this.configDistance(config);
            this.configEpsilon(config);
        }

        protected void configDistance(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distfun = x;
            });
        }

        protected void configEpsilon(Parameterization config) {
            new DoubleParameter(DBSCAN.Par.EPSILON_ID).grab(config, x -> {
                this.epsilon = x;
            });
        }
    }

    public static abstract class Instance<N, M>
    implements NeighborPredicate.Instance<N> {
        protected DBIDs ids;
        protected DataStore<M> storage;

        public Instance(DBIDs ids, DataStore<M> storage) {
            this.ids = ids;
            this.storage = storage;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }
    }
}

