/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.correlation.COPAC;
import elki.clustering.dbscan.predicates.AbstractRangeQueryNeighborPredicate;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNList;
import elki.database.ids.SetDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.PCAFilteredResult;
import elki.math.linearalgebra.pca.PCAResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM Int. Conf. on Data Mining (SDM'07)", url="https://doi.org/10.1137/1.9781611972771.37", bibkey="DBLP:conf/sdm/AchtertBKKZ07")
public class COPACNeighborPredicate
implements NeighborPredicate<COPACModel> {
    private static final Logging LOG = Logging.getLogger(COPACNeighborPredicate.class);
    protected final COPAC.Settings settings;
    protected double epsilonsq;

    public COPACNeighborPredicate(COPAC.Settings settings) {
        this.settings = settings;
        this.epsilonsq = settings.epsilon * settings.epsilon;
    }

    @Override
    public NeighborPredicate.Instance<COPACModel> instantiate(Database database) {
        return this.instantiate((Relation<? extends NumberVector>)database.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]));
    }

    public Instance instantiate(Relation<? extends NumberVector> relation) {
        KNNSearcher knnq = new QueryBuilder(relation, (Distance)EuclideanDistance.STATIC).kNNByDBID(this.settings.k);
        WritableDataStore storage = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, COPACModel.class);
        Duration time = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList ref = knnq.getKNN((Object)iditer, this.settings.k);
            storage.put((DBIDRef)iditer, (Object)this.computeLocalModel((DBIDRef)iditer, (DoubleDBIDList)ref, relation));
            LOG.incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.statistics((Statistic)time.end());
        return new Instance(relation.getDBIDs(), (DataStore<COPACModel>)storage);
    }

    protected COPACModel computeLocalModel(DBIDRef id, DoubleDBIDList knnneighbors, Relation<? extends NumberVector> relation) {
        double[] vecP;
        PCAResult epairs = this.settings.pca.processIds((DBIDs)knnneighbors, relation);
        int pdim = this.settings.filter.filter(epairs.getEigenvalues());
        if (pdim == (vecP = ((NumberVector)relation.get(id)).toArray()).length) {
            return new COPACModel(pdim, (SetDBIDs)DBIDUtil.EMPTYDBIDS);
        }
        double[][] mat = new PCAFilteredResult(epairs.getEigenPairs(), pdim, 1.0, 0.0).similarityMatrix();
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet();
        DBIDIter neighbor = relation.iterDBIDs();
        while (neighbor.valid()) {
            double[] diff = VMath.minusEquals((double[])((NumberVector)relation.get((DBIDRef)neighbor)).toArray(), (double[])vecP);
            double cdistP = VMath.transposeTimesTimes((double[])diff, (double[][])mat, (double[])diff);
            if (cdistP <= this.epsilonsq) {
                survivors.add((DBIDRef)neighbor);
            }
            neighbor.advance();
        }
        return new COPACModel(pdim, (SetDBIDs)survivors);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<COPACModel> getOutputType() {
        return new SimpleTypeInformation(COPACModel.class);
    }

    public static class Par
    implements Parameterizer {
        protected COPAC.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (COPAC.Settings)config.tryInstantiate(COPAC.Settings.class);
        }

        public COPACNeighborPredicate make() {
            return new COPACNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<COPACModel, COPACModel> {
        public Instance(DBIDs ids, DataStore<COPACModel> storage) {
            super(ids, storage);
        }

        @Override
        public COPACModel getNeighbors(DBIDRef reference) {
            COPACModel asymmetric = (COPACModel)this.storage.get(reference);
            if (asymmetric.ids.size() <= 0) {
                return asymmetric;
            }
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((int)asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                COPACModel nmodel = (COPACModel)this.storage.get((DBIDRef)neighbor);
                if (nmodel.cdim == asymmetric.cdim && nmodel.ids.contains(reference)) {
                    ids.add((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            return new COPACModel(asymmetric.cdim, (SetDBIDs)ids);
        }

        @Override
        public DBIDIter iterDBIDs(COPACModel neighbors) {
            return neighbors.ids.iter();
        }

        public int dimensionality(DBIDRef id) {
            return ((COPACModel)this.storage.get((DBIDRef)id)).cdim;
        }
    }

    public static class COPACModel
    implements SetDBIDs {
        int cdim;
        SetDBIDs ids;

        public COPACModel(int cdim, SetDBIDs ids) {
            this.cdim = cdim;
            this.ids = ids;
        }

        public DBIDIter iter() {
            return this.ids.iter();
        }

        public int size() {
            return this.ids.size();
        }

        public boolean contains(DBIDRef o) {
            return this.ids.contains(o);
        }

        public boolean isEmpty() {
            return this.ids.isEmpty();
        }
    }
}

