/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.correlation.ERiC;
import elki.clustering.dbscan.predicates.AbstractRangeQueryNeighborPredicate;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.PCAFilteredResult;
import elki.math.linearalgebra.pca.PCAResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Peter Kriegel, Peer Kr\u00f6ger, Arthur Zimek", title="On Exploring Complex Relationships of Correlation Clusters", booktitle="Proc. 19th Int. Conf. Scientific and Statistical Database Management (SSDBM 2007)", url="https://doi.org/10.1109/SSDBM.2007.21", bibkey="DBLP:conf/ssdbm/AchtertBKKZ07")
public class ERiCNeighborPredicate
implements NeighborPredicate<DBIDs> {
    private static final Logging LOG = Logging.getLogger(ERiCNeighborPredicate.class);
    protected final ERiC.Settings settings;
    private double deltasq;

    public ERiCNeighborPredicate(ERiC.Settings settings) {
        this.settings = settings;
        this.deltasq = settings.delta * settings.delta;
    }

    public Instance instantiate(Database database) {
        return this.instantiate((Relation<? extends NumberVector>)database.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]));
    }

    public Instance instantiate(Relation<? extends NumberVector> relation) {
        KNNSearcher knnq = new QueryBuilder(relation, (Distance)EuclideanDistance.STATIC).kNNByDBID(this.settings.k);
        WritableDataStore storage = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, PCAFilteredResult.class);
        Duration time = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList ref = knnq.getKNN((Object)iditer, this.settings.k);
            PCAResult pcares = this.settings.pca.processQueryResult((DoubleDBIDList)ref, relation);
            storage.put((DBIDRef)iditer, (Object)new PCAFilteredResult(pcares.getEigenPairs(), this.settings.filter.filter(pcares.getEigenvalues()), 1.0, 0.0));
            LOG.incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.statistics((Statistic)time.end());
        return new Instance(relation.getDBIDs(), (DataStore<PCAFilteredResult>)storage, relation);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<DBIDs> getOutputType() {
        return new SimpleTypeInformation(DBIDs.class);
    }

    public static class Par
    implements Parameterizer {
        protected ERiC.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (ERiC.Settings)config.tryInstantiate(ERiC.Settings.class);
        }

        public ERiCNeighborPredicate make() {
            return new ERiCNeighborPredicate(this.settings);
        }
    }

    public class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<DBIDs, PCAFilteredResult> {
        private Relation<? extends NumberVector> relation;

        public Instance(DBIDs ids, DataStore<PCAFilteredResult> storage, Relation<? extends NumberVector> relation) {
            super(ids, storage);
            this.relation = relation;
        }

        @Override
        public DBIDs getNeighbors(DBIDRef reference) {
            PCAFilteredResult pca1 = (PCAFilteredResult)this.storage.get(reference);
            NumberVector v1 = (NumberVector)this.relation.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
            DBIDIter neighbor = this.relation.iterDBIDs();
            while (neighbor.valid()) {
                PCAFilteredResult pca2 = (PCAFilteredResult)this.storage.get((DBIDRef)neighbor);
                NumberVector v2 = (NumberVector)this.relation.get((DBIDRef)neighbor);
                if (this.strongNeighbors(v1, v2, pca1, pca2)) {
                    ids.add((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            return ids;
        }

        @Override
        public DBIDIter iterDBIDs(DBIDs neighbors) {
            return neighbors.iter();
        }

        public boolean strongNeighbors(NumberVector v1, NumberVector v2, PCAFilteredResult pca1, PCAFilteredResult pca2) {
            if (pca1.getCorrelationDimension() != pca2.getCorrelationDimension() || !this.approximatelyLinearDependent(pca1, pca2) || !this.approximatelyLinearDependent(pca2, pca1)) {
                return false;
            }
            double[] v = VMath.minusEquals((double[])v1.toArray(), (double[])v2.toArray());
            return VMath.transposeTimesTimes((double[])v, (double[][])pca1.similarityMatrix(), (double[])v) <= ERiCNeighborPredicate.this.settings.tau && VMath.transposeTimesTimes((double[])v, (double[][])pca2.similarityMatrix(), (double[])v) <= ERiCNeighborPredicate.this.settings.tau;
        }

        public boolean weakNeighbors(double[] v1, double[] v2, PCAFilteredResult pca1, PCAFilteredResult pca2) {
            if (pca1.getCorrelationDimension() < pca2.getCorrelationDimension() || !this.approximatelyLinearDependent(pca1, pca2) || pca1.getCorrelationDimension() == pca2.getCorrelationDimension() && !this.approximatelyLinearDependent(pca2, pca1)) {
                return false;
            }
            double[] v = VMath.minus((double[])v1, (double[])v2);
            return VMath.transposeTimesTimes((double[])v, (double[][])pca1.similarityMatrix(), (double[])v) <= ERiCNeighborPredicate.this.settings.tau && (pca1.getCorrelationDimension() != pca2.getCorrelationDimension() || VMath.transposeTimesTimes((double[])v, (double[][])pca2.similarityMatrix(), (double[])v) <= ERiCNeighborPredicate.this.settings.tau);
        }

        protected boolean approximatelyLinearDependent(PCAFilteredResult p1, PCAFilteredResult p2) {
            double[][] m1_czech = p1.dissimilarityMatrix();
            double[][] v2_strong = p2.getStrongEigenvectors();
            for (int i = 0; i < v2_strong.length; ++i) {
                double[] v2_i = v2_strong[i];
                double distsq = VMath.squareSum((double[])v2_i) - VMath.transposeTimesTimes((double[])v2_i, (double[][])m1_czech, (double[])v2_i);
                if (!(distsq > ERiCNeighborPredicate.this.deltasq)) continue;
                return false;
            }
            return true;
        }

        public int dimensionality(DBIDRef id) {
            return ((PCAFilteredResult)this.storage.get(id)).getCorrelationDimension();
        }
    }
}

