/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.Algorithm;
import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.predicates.NeighborPredicate;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96")
public class EpsilonNeighborPredicate<O>
implements NeighborPredicate<DoubleDBIDList> {
    protected double epsilon;
    protected Distance<? super O> distance;

    public EpsilonNeighborPredicate(double epsilon, Distance<? super O> distance) {
        this.epsilon = epsilon;
        this.distance = distance;
    }

    public Instance instantiate(Database database) {
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        RangeSearcher rq = new QueryBuilder(relation, this.distance).rangeByDBID(this.epsilon);
        return new Instance(this.epsilon, (RangeSearcher<DBIDRef>)rq, relation.getDBIDs());
    }

    @Override
    public SimpleTypeInformation<DoubleDBIDList> getOutputType() {
        return TypeUtil.NEIGHBORLIST;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Par<O>
    implements Parameterizer {
        protected double epsilon;
        protected Distance<O> distfun = null;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distfun = x;
            });
            ((DoubleParameter)new DoubleParameter(DBSCAN.Par.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.epsilon = x;
            });
        }

        public EpsilonNeighborPredicate<O> make() {
            return new EpsilonNeighborPredicate<O>(this.epsilon, this.distfun);
        }
    }

    public static class Instance
    implements NeighborPredicate.Instance<DoubleDBIDList> {
        protected double epsilon;
        protected RangeSearcher<DBIDRef> rq;
        protected DBIDs ids;

        public Instance(double epsilon, RangeSearcher<DBIDRef> rq, DBIDs ids) {
            this.epsilon = epsilon;
            this.rq = rq;
            this.ids = ids;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }

        @Override
        public DoubleDBIDList getNeighbors(DBIDRef reference) {
            return this.rq.getRange((Object)reference, this.epsilon, DBIDUtil.newDistanceDBIDList());
        }

        @Override
        public DBIDIter iterDBIDs(DoubleDBIDList neighbors) {
            return neighbors.iter();
        }
    }
}

