/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.correlation.FourC;
import elki.clustering.dbscan.predicates.CorePredicate;
import elki.clustering.dbscan.predicates.PreDeConNeighborPredicate;
import elki.data.type.SimpleTypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourCCorePredicate
implements CorePredicate<PreDeConNeighborPredicate.PreDeConModel> {
    protected FourC.Settings settings;

    public FourCCorePredicate(FourC.Settings settings) {
        this.settings = settings;
    }

    public Instance instantiate(Database database) {
        return new Instance(this.settings);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<? extends PreDeConNeighborPredicate.PreDeConModel> type) {
        return type.getRestrictionClass().isAssignableFrom(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Par
    implements Parameterizer {
        protected FourC.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (FourC.Settings)config.tryInstantiate(FourC.Settings.class);
        }

        public FourCCorePredicate make() {
            return new FourCCorePredicate(this.settings);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<PreDeConNeighborPredicate.PreDeConModel> {
        protected FourC.Settings settings;

        public Instance(FourC.Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean isCorePoint(DBIDRef point, PreDeConNeighborPredicate.PreDeConModel model) {
            return model.pdim <= this.settings.lambda && model.ids.size() >= this.settings.minpts;
        }
    }
}

