/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.correlation.FourC;
import elki.clustering.dbscan.predicates.AbstractRangeQueryNeighborPredicate;
import elki.clustering.dbscan.predicates.PreDeConNeighborPredicate;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.math.MeanVariance;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import elki.math.linearalgebra.pca.PCAFilteredResult;
import elki.math.linearalgebra.pca.PCAResult;
import elki.math.linearalgebra.pca.PCARunner;
import elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import elki.math.linearalgebra.pca.filter.EigenPairFilter;
import elki.math.linearalgebra.pca.filter.LimitEigenPairFilter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourCNeighborPredicate
extends AbstractRangeQueryNeighborPredicate<NumberVector, PreDeConNeighborPredicate.PreDeConModel, PreDeConNeighborPredicate.PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(FourCNeighborPredicate.class);
    private FourC.Settings settings;
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvSize2 = new MeanVariance();
    private MeanVariance mvCorDim = new MeanVariance();
    private PCARunner pca;
    private EigenPairFilter filter;

    public FourCNeighborPredicate(FourC.Settings settings) {
        super(settings.epsilon, EuclideanDistance.STATIC);
        this.settings = settings;
        this.pca = new PCARunner((CovarianceMatrixBuilder)new StandardCovarianceMatrixBuilder());
        this.filter = new LimitEigenPairFilter(settings.delta, settings.absolute);
    }

    public Instance instantiate(Database database) {
        Relation relation = database.getRelation(this.getInputTypeRestriction(), new Object[0]);
        RangeSearcher rq = new QueryBuilder(relation, this.distance).rangeByDBID(this.epsilon);
        this.mvSize.reset();
        this.mvSize2.reset();
        this.mvCorDim.reset();
        DataStore<PreDeConNeighborPredicate.PreDeConModel> storage = this.preprocess(PreDeConNeighborPredicate.PreDeConModel.class, relation, (RangeSearcher<DBIDRef>)rq);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Average neighborhood size: " + this.mvSize.toString()));
            LOG.verbose((CharSequence)("Average correlation dimensionality: " + this.mvCorDim.toString()));
            LOG.verbose((CharSequence)("Average correlated neighborhood size: " + this.mvSize2.toString()));
            int dim = RelationUtil.dimensionality((Relation)relation);
            if (this.mvSize.getMean() < (double)(5 * dim)) {
                LOG.verbose((CharSequence)"The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose((CharSequence)"The epsilon parameter may be chosen too large.");
            } else if (this.mvSize2.getMean() < 10.0) {
                LOG.verbose((CharSequence)"The epsilon parameter may be chosen too large, or delta too small.");
            } else if (this.mvSize2.getMean() < (double)this.settings.minpts) {
                LOG.verbose((CharSequence)"The minPts parameter may be chosen too large.");
            } else {
                LOG.verbose((CharSequence)("As a first guess, you can try minPts < " + (int)this.mvSize2.getMean() + ", but you will need to experiment with these parameters and epsilon."));
            }
        }
        return new Instance(relation.getDBIDs(), storage);
    }

    @Override
    protected PreDeConNeighborPredicate.PreDeConModel computeLocalModel(DBIDRef id, DoubleDBIDList neighbors, Relation<? extends NumberVector> relation) {
        this.mvSize.put((double)neighbors.size());
        PCAResult epairs = this.pca.processIds((DBIDs)neighbors, relation);
        int cordim = this.filter.filter(epairs.getEigenvalues());
        PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), cordim, this.settings.kappa, 1.0);
        double[][] m_hat = pcares.similarityMatrix();
        double[] obj = ((NumberVector)relation.get(id)).toArray();
        double sqeps = this.settings.epsilon * this.settings.epsilon;
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet((int)neighbors.size());
        DoubleDBIDListIter iter = neighbors.iter();
        while (iter.valid()) {
            double[] diff = VMath.minusEquals((double[])((NumberVector)relation.get((DBIDRef)iter)).toArray(), (double[])obj);
            double dist = VMath.transposeTimesTimes((double[])diff, (double[][])m_hat, (double[])diff);
            if (dist <= sqeps) {
                survivors.add((DBIDRef)iter);
            }
            iter.advance();
        }
        if (cordim <= this.settings.lambda) {
            this.mvSize2.put((double)survivors.size());
        }
        this.mvCorDim.put((double)cordim);
        return new PreDeConNeighborPredicate.PreDeConModel(cordim, (SetDBIDs)survivors);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<PreDeConNeighborPredicate.PreDeConModel> getOutputType() {
        return new SimpleTypeInformation(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Par
    implements Parameterizer {
        protected FourC.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (FourC.Settings)config.tryInstantiate(FourC.Settings.class);
        }

        public FourCNeighborPredicate make() {
            return new FourCNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConNeighborPredicate.PreDeConModel, PreDeConNeighborPredicate.PreDeConModel> {
        public Instance(DBIDs ids, DataStore<PreDeConNeighborPredicate.PreDeConModel> storage) {
            super(ids, storage);
        }

        @Override
        public PreDeConNeighborPredicate.PreDeConModel getNeighbors(DBIDRef reference) {
            PreDeConNeighborPredicate.PreDeConModel asymmetric = (PreDeConNeighborPredicate.PreDeConModel)this.storage.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((int)asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                if (((PreDeConNeighborPredicate.PreDeConModel)this.storage.get((DBIDRef)neighbor)).ids.contains(reference)) {
                    ids.add((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            return new PreDeConNeighborPredicate.PreDeConModel(asymmetric.pdim, (SetDBIDs)ids);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConNeighborPredicate.PreDeConModel neighbors) {
            return neighbors.ids.iter();
        }
    }
}

