/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.predicates.CorePredicate;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96")
public class MinPtsCorePredicate
implements CorePredicate<DBIDs> {
    public static final Logging LOG = Logging.getLogger(MinPtsCorePredicate.class);
    protected int minpts;

    public MinPtsCorePredicate(int minpts) {
        this.minpts = minpts;
    }

    public Instance instantiate(Database database) {
        return new Instance(this.minpts);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<? extends DBIDs> type) {
        return TypeUtil.DBIDS.isAssignableFromType(type) || TypeUtil.NEIGHBORLIST.isAssignableFromType(type);
    }

    public static class Par
    implements Parameterizer {
        protected int minpts;

        public void configure(Parameterization config) {
            if (((IntParameter)new IntParameter(DBSCAN.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            }) && this.minpts <= 2) {
                LOG.warning((CharSequence)"DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
            }
        }

        public MinPtsCorePredicate make() {
            return new MinPtsCorePredicate(this.minpts);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<DBIDs> {
        protected int minpts;

        public Instance(int minpts) {
            this.minpts = minpts;
        }

        @Override
        public boolean isCorePoint(DBIDRef point, DBIDs neighbors) {
            return neighbors.size() >= this.minpts;
        }
    }
}

